package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.NamespaceImportedMemberMatch;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.namespaceImportedMember pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NamespaceImportedMemberProcessor implements IMatchProcessor<NamespaceImportedMemberMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pNamespace the value of pattern parameter namespace in the currently processed match
   * @param pImportedMember the value of pattern parameter importedMember in the currently processed match
   * 
   */
  public abstract void process(final Namespace pNamespace, final PackageableElement pImportedMember);
  
  @Override
  public void process(final NamespaceImportedMemberMatch match) {
    process(match.getNamespace(), match.getImportedMember());
  }
}
