package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.StateIsCompositeMatch;
import org.eclipse.uml2.uml.State;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.stateIsComposite pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class StateIsCompositeProcessor implements IMatchProcessor<StateIsCompositeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pIsComposite the value of pattern parameter isComposite in the currently processed match
   * 
   */
  public abstract void process(final State pSelf, final Boolean pIsComposite);
  
  @Override
  public void process(final StateIsCompositeMatch match) {
    process(match.getSelf(), match.getIsComposite());
  }
}
