/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.BaseContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatchContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class QueryExplorerLabelProvider
extends ColumnLabelProvider {
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return property.matches("text");
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public Image getImage(Object element) {
        ImageRegistry imageRegistry = IncQueryGUIPlugin.getDefault().getImageRegistry();
        if (element instanceof PatternMatcherRootContent) {
            PatternMatcherRootContent root = (PatternMatcherRootContent)element;
            if (root.isTainted() || root.getStatus().getSeverity() == 4) {
                return imageRegistry.get("error");
            }
            return imageRegistry.get("navigator_root");
        }
        if (element instanceof PatternMatcherContent) {
            if (((PatternMatcherContent)element).isCreated()) {
                return imageRegistry.get("matcher");
            }
            return imageRegistry.get("error");
        }
        if (element instanceof PatternMatchContent) {
            return imageRegistry.get("match");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof BaseContent) {
            return ((BaseContent)element).getText();
        }
        return null;
    }

    public String getToolTipText(Object element) {
        List pProblems;
        if (element instanceof PatternMatcherRootContent) {
            IStatus status = ((PatternMatcherRootContent)element).getStatus();
            if (!status.isOK()) {
                return String.format("%s. For details, check the Error Log view.", status.getMessage());
            }
        } else if (element instanceof PatternMatcherContent && !(pProblems = ((PatternMatcherContent)element).getSpecification().getInternalQueryRepresentation().getPProblems()).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("The following problems have been detected in the query specification: \n");
            for (PProblem pProblem : pProblems) {
                sb.append(String.format(" * %s%n", pProblem.getShortMessage()));
            }
            return sb.toString();
        }
        return super.getToolTipText(element);
    }

    public Color getForeground(Object element) {
        PatternMatcherContent matcher;
        Display display = Display.getCurrent();
        if (element instanceof PatternMatcherContent && (matcher = (PatternMatcherContent)element).isGenerated()) {
            return display.getSystemColor(16);
        }
        return display.getSystemColor(2);
    }
}

