/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout;

import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.DrawUtils;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.FlyoutConstants;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.FlyoutControlComposite;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.ICursorConstants;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;

public class FlyoutContainer
extends Composite {
    private static final int RESIZE_WIDTH = 5;
    private static final int TITLE_LINES = 30;
    private static final int TITLE_MARGIN = 5;
    private static final Font TITLE_FONT = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private static final Image PIN = FlyoutContainer.loadImage("pin");
    private static final Image ARROW_LEFT = FlyoutContainer.loadImage("arrow_left");
    private static final Image ARROW_RIGHT = FlyoutContainer.loadImage("arrow_right");
    private static final Image ARROW_TOP = FlyoutContainer.loadImage("arrow_top");
    private static final Image ARROW_BOTTOM = FlyoutContainer.loadImage("arrow_bottom");
    private FlyoutControlComposite flyoutControl;
    private int titleWidth;
    private int titleHeight;
    private Image titleImage;
    private Image titleImageRotated;
    private boolean isResizable;
    private boolean stateHover;
    private Image backImage;

    private static Image loadImage(String key) {
        ImageRegistry registry = IncQueryGUIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(key);
        return image;
    }

    public FlyoutContainer(FlyoutControlComposite flyoutControl, int style) {
        super((Composite)flyoutControl, style);
        this.flyoutControl = flyoutControl;
        this.configureMenu();
        this.updateTitleImage("title");
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (FlyoutContainer.this.titleImage != null) {
                    FlyoutContainer.this.titleImage.dispose();
                    FlyoutContainer.this.titleImageRotated.dispose();
                    FlyoutContainer.this.titleImage = null;
                    FlyoutContainer.this.titleImageRotated = null;
                }
                if (FlyoutContainer.this.backImage != null) {
                    FlyoutContainer.this.backImage.dispose();
                    FlyoutContainer.this.backImage = null;
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FlyoutContainer.this.layout();
            }
        };
        this.addListener(10, listener);
        this.addListener(11, listener);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                FlyoutContainer.this.handlePaint(event.gc);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 1) {
                    FlyoutContainer.this.handle_mouseDown(event);
                }
            }

            public void mouseUp(MouseEvent event) {
                if (event.button == 1) {
                    FlyoutContainer.this.handle_mouseUp(event);
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                FlyoutContainer.this.stateHover = false;
                FlyoutContainer.this.redraw();
                FlyoutContainer.this.setCursor(null);
            }

            public void mouseHover(MouseEvent e) {
                FlyoutContainer.this.handle_mouseHover();
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                FlyoutContainer.this.handle_mouseMove(event);
            }
        });
    }

    private void handle_mouseDown(MouseEvent event) {
        if (this.stateHover) {
            int state = this.flyoutControl.getPreferences().getState();
            state = state == 0 ? 1 : 0;
            this.flyoutControl.getPreferences().setState(state);
            this.redraw();
            this.flyoutControl.layout();
        } else if (this.getCursor() == ICursorConstants.SIZEWE || this.getCursor() == ICursorConstants.SIZENS) {
            this.isResizable = true;
        } else if (this.getCursor() == ICursorConstants.SIZEALL) {
            this.handleDocking();
        }
    }

    private void handle_mouseUp(MouseEvent event) {
        if (this.isResizable) {
            this.isResizable = false;
            this.handle_mouseMove(event);
        }
    }

    private void handle_mouseMove(MouseEvent event) {
        if (this.isResizable) {
            int width = this.flyoutControl.isHorizontal() ? this.getSize().x : this.getSize().y;
            int newWidth = width;
            if (this.flyoutControl.isWest()) {
                newWidth = event.x + 2;
            } else if (this.flyoutControl.isEast()) {
                newWidth = width - event.x + 2;
            } else if (this.flyoutControl.isNorth()) {
                newWidth = event.y + 2;
            } else if (this.flyoutControl.isSouth()) {
                newWidth = width - event.y + 2;
            }
            if (newWidth != width) {
                this.flyoutControl.getPreferences().setWidth(newWidth);
                this.redraw();
                this.flyoutControl.layout();
            }
        } else {
            Rectangle clientArea = this.getClientArea();
            boolean inside = clientArea.contains(event.x, event.y);
            int x = event.x;
            int y = event.y;
            if (inside) {
                boolean oldStateHover = this.stateHover;
                if (this.flyoutControl.isEast()) {
                    this.stateHover = x > clientArea.width - this.titleHeight && y < this.titleHeight;
                } else {
                    boolean bl = this.stateHover = x < this.titleHeight && y < this.titleHeight;
                }
                if (this.stateHover != oldStateHover) {
                    this.redraw();
                }
                if (this.stateHover) {
                    this.setCursor(null);
                    return;
                }
                if (this.isOpenExpanded()) {
                    if (this.flyoutControl.isWest() && x >= clientArea.width - 5) {
                        this.setCursor(ICursorConstants.SIZEWE);
                    } else if (this.flyoutControl.isEast() && x <= 5) {
                        this.setCursor(ICursorConstants.SIZEWE);
                    } else if (this.flyoutControl.isNorth() && y >= clientArea.height - 5) {
                        this.setCursor(ICursorConstants.SIZENS);
                    } else if (this.flyoutControl.isSouth() && y <= 5) {
                        this.setCursor(ICursorConstants.SIZENS);
                    } else {
                        this.setCursor(null);
                    }
                }
                if (this.getCursor() == null) {
                    this.setCursor(ICursorConstants.SIZEALL);
                }
            } else {
                this.setCursor(null);
            }
        }
    }

    private void handle_mouseHover() {
        if (this.flyoutControl.getPreferences().getState() == 1 && !this.stateHover) {
            this.flyoutControl.getPreferences().setState(2);
            this.flyoutControl.layout();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 12) {
                        FlyoutContainer.this.getDisplay().removeFilter(5, (Listener)this);
                    } else {
                        Point p = ((Control)event.widget).toDisplay(event.x, event.y);
                        if (FlyoutContainer.this.isResizable) {
                            return;
                        }
                        if (FlyoutContainer.this.getClientArea().contains(FlyoutContainer.this.toControl(p.x, p.y))) {
                            return;
                        }
                        if (FlyoutContainer.this.flyoutControl.getClientArea().contains(FlyoutContainer.this.flyoutControl.toControl(p.x, p.y))) {
                            FlyoutContainer.this.getDisplay().removeFilter(5, (Listener)this);
                            if (FlyoutContainer.this.flyoutControl.getPreferences().getState() == 2) {
                                FlyoutContainer.this.flyoutControl.getPreferences().setState(1);
                                FlyoutContainer.this.flyoutControl.layout();
                            }
                        }
                    }
                }
            };
            this.addListener(12, listener);
            this.getDisplay().addFilter(5, listener);
        }
    }

    private void handleDocking() {
        final int width = this.flyoutControl.getPreferences().getWidth();
        final int oldDockLocation = this.flyoutControl.getDockLocation();
        final int[] newDockLocation = new int[]{oldDockLocation};
        final Tracker dockingTracker = new Tracker((Composite)this.flyoutControl, 0);
        dockingTracker.setRectangles(new Rectangle[]{this.getBounds()});
        dockingTracker.setStippled(true);
        dockingTracker.addListener(10, new Listener(){

            public void handleEvent(Event event2) {
                Rectangle clientArea = FlyoutContainer.this.flyoutControl.getClientArea();
                Point location = FlyoutContainer.this.flyoutControl.toControl(event2.x, event2.y);
                int h3 = clientArea.height / 3;
                if (location.y < h3 && FlyoutContainer.this.flyoutControl.isValidDockLocation(4)) {
                    dockingTracker.setRectangles(new Rectangle[]{new Rectangle(0, 0, clientArea.width, width)});
                    newDockLocation[0] = 4;
                } else if (location.y > 2 * h3 && FlyoutContainer.this.flyoutControl.isValidDockLocation(8)) {
                    dockingTracker.setRectangles(new Rectangle[]{new Rectangle(0, clientArea.height - width, clientArea.width, width)});
                    newDockLocation[0] = 8;
                } else if (location.x < clientArea.width / 2 && FlyoutContainer.this.flyoutControl.isValidDockLocation(1)) {
                    dockingTracker.setRectangles(new Rectangle[]{new Rectangle(0, 0, width, clientArea.height)});
                    newDockLocation[0] = 1;
                } else if (FlyoutContainer.this.flyoutControl.isValidDockLocation(2)) {
                    dockingTracker.setRectangles(new Rectangle[]{new Rectangle(clientArea.width - width, 0, width, clientArea.height)});
                    newDockLocation[0] = 2;
                } else {
                    dockingTracker.setRectangles(new Rectangle[]{FlyoutContainer.this.getBounds()});
                    newDockLocation[0] = oldDockLocation;
                }
            }
        });
        if (dockingTracker.open()) {
            this.flyoutControl.setDockLocation(newDockLocation[0]);
        }
        dockingTracker.dispose();
    }

    public Control getControl() {
        Control[] children = this.getChildren();
        return children.length == 1 ? children[0] : null;
    }

    public void setTitleText(String text) {
        this.updateTitleImage(text);
    }

    public void layout() {
        Control control = this.getControl();
        if (control == null) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        if (this.isOpenExpanded()) {
            if (this.flyoutControl.isWest()) {
                int y = this.titleHeight;
                control.setBounds(0, y, clientArea.width - 5, clientArea.height - y);
            } else if (this.flyoutControl.isEast()) {
                int y = this.titleHeight;
                control.setBounds(5, y, clientArea.width - 5, clientArea.height - y);
            } else if (this.flyoutControl.isNorth()) {
                int y = this.titleHeight;
                control.setBounds(0, y, clientArea.width, clientArea.height - y - 5);
            } else if (this.flyoutControl.isSouth()) {
                int y = 5 + this.titleHeight;
                control.setBounds(0, y, clientArea.width, clientArea.height - y);
            }
        } else {
            control.setBounds(0, 0, 0, 0);
        }
    }

    private void handlePaint(GC paintGC) {
        Rectangle clientArea = this.getClientArea();
        if (this.backImage == null || !this.backImage.getBounds().equals((Object)clientArea)) {
            if (this.backImage != null) {
                this.backImage.dispose();
            }
            this.backImage = new Image((Device)this.getDisplay(), clientArea.width, clientArea.height);
        }
        GC gc = new GC((Drawable)this.backImage);
        gc.setBackground(paintGC.getBackground());
        gc.setForeground(paintGC.getForeground());
        gc.fillRectangle(clientArea);
        if (this.isOpenExpanded()) {
            if (this.flyoutControl.isWest()) {
                this.drawStateImage(gc, 0, 0);
                gc.drawImage(this.titleImage, this.titleHeight, 0);
            } else if (this.flyoutControl.isEast()) {
                int x = clientArea.width - this.titleHeight;
                this.drawStateImage(gc, x, 0);
                gc.drawImage(this.titleImage, x - this.titleWidth, 0);
            } else if (this.flyoutControl.isNorth()) {
                this.drawStateImage(gc, 0, 0);
                gc.drawImage(this.titleImage, this.titleHeight, 0);
            } else if (this.flyoutControl.isSouth()) {
                int y = 5;
                this.drawStateImage(gc, 0, y);
                gc.drawImage(this.titleImage, this.titleHeight, y);
            }
            this.drawResizeBand(gc);
        } else {
            if (this.flyoutControl.isHorizontal()) {
                this.drawStateImage(gc, 0, 0);
                gc.drawImage(this.titleImageRotated, 0, this.titleHeight);
            } else {
                this.drawStateImage(gc, 0, 0);
                gc.drawImage(this.titleImage, this.titleHeight, 0);
            }
            DrawUtils.drawHighlightRectangle(gc, 0, 0, clientArea.width, clientArea.height);
        }
        gc.dispose();
        paintGC.drawImage(this.backImage, 0, 0);
    }

    private void drawStateImage(GC gc, int x, int y) {
        DrawUtils.drawImageCHCV(gc, this.getStateImage(), x, y, this.titleHeight, this.titleHeight);
        if (this.stateHover) {
            DrawUtils.drawHighlightRectangle(gc, x, y, this.titleHeight, this.titleHeight);
        }
    }

    private Image getStateImage() {
        int location = this.flyoutControl.getDockLocation();
        int state = this.flyoutControl.getPreferences().getState();
        if (state == 0) {
            switch (location) {
                case 1: {
                    return ARROW_LEFT;
                }
                case 2: {
                    return ARROW_RIGHT;
                }
                case 4: {
                    return ARROW_TOP;
                }
                case 8: {
                    return ARROW_BOTTOM;
                }
            }
        } else {
            if (state == 2) {
                return PIN;
            }
            switch (location) {
                case 1: {
                    return ARROW_RIGHT;
                }
                case 2: {
                    return ARROW_LEFT;
                }
                case 4: {
                    return ARROW_BOTTOM;
                }
                case 8: {
                    return ARROW_TOP;
                }
            }
        }
        return null;
    }

    private void drawResizeBand(GC gc) {
        int height;
        int width;
        int y;
        int x;
        Rectangle clientArea = this.getClientArea();
        if (this.flyoutControl.isHorizontal()) {
            x = this.flyoutControl.isWest() ? clientArea.width - 5 : 0;
            y = 0;
            width = 5;
            height = clientArea.height;
        } else {
            x = 0;
            y = this.flyoutControl.isNorth() ? clientArea.height - 5 : 0;
            width = clientArea.width;
            height = 5;
        }
        DrawUtils.drawHighlightRectangle(gc, x, y, width, height);
    }

    private boolean isOpenExpanded() {
        int state = this.flyoutControl.getPreferences().getState();
        return state == 0 || state == 2;
    }

    private void updateTitleImage(String text) {
        GC gc = new GC((Drawable)this);
        gc.setFont(TITLE_FONT);
        Point textSize = gc.textExtent(text);
        gc.dispose();
        if (this.titleImage != null) {
            this.titleImage.dispose();
            this.titleImageRotated.dispose();
        }
        this.titleWidth = textSize.x + 60 + 20;
        this.titleHeight = textSize.y;
        this.titleImage = new Image((Device)this.getDisplay(), this.titleWidth, this.titleHeight);
        gc = new GC((Drawable)this.titleImage);
        try {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, this.titleWidth, this.titleHeight);
            gc.setForeground(FlyoutConstants.BLACK);
            gc.setFont(TITLE_FONT);
            gc.drawText(text, 0, 0);
        }
        finally {
            gc.dispose();
        }
        this.titleImageRotated = DrawUtils.createRotatedImage(this.titleImage);
    }

    private void configureMenu() {
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public int getTitleWidth() {
        return this.titleWidth;
    }
}

