/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.incquery.tooling.ui.queryexplorer.handlers.RuntimeMatcherUnRegistrator;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.BasePartListener;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

public class FileEditorPartListener
extends BasePartListener {
    private static final String dialogTitle = ".eiq file editor closing";

    @Override
    public void partClosed(IWorkbenchPart part) {
        IFile file;
        IEditorPart closedEditor;
        IEditorInput editorInput;
        if (part instanceof IEditorPart && (editorInput = (closedEditor = (IEditorPart)part).getEditorInput()) instanceof FileEditorInput && (file = ((FileEditorInput)editorInput).getFile()) != null && file.getFileExtension().matches("eiq") && QueryExplorerPatternRegistry.getInstance().getFiles().contains(file)) {
            String question = "There are patterns (from file named '" + file.getName() + "') registered in the Query Explorer.\nWould you like to unregister them?";
            boolean answer = MessageDialog.openQuestion((Shell)closedEditor.getSite().getShell(), (String)dialogTitle, (String)question);
            if (answer) {
                RuntimeMatcherUnRegistrator job = new RuntimeMatcherUnRegistrator(file);
                job.run();
            }
        }
    }
}

