/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.detail;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.MatcherConfiguration;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.ModelElementListDialogLabelProvider;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.TableViewerUtil;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ModelElementCellEditor
extends CellEditor {
    private Composite editor;
    private Control contents;
    private Text inputText;
    private Button dialogButton;
    private Button clearButton;
    private KeyListener keyListener;
    private Object value = null;
    private Notifier root;
    private Table table;
    private ObservablePatternMatcher observableMatcher;
    @Inject
    TableViewerUtil tableViewerUtil;
    private DialogCellLayout layout;

    public ModelElementCellEditor(Table table, ObservablePatternMatcher observableMatcher) {
        super((Composite)table, 0);
        this.root = observableMatcher.getParent().getNotifier();
        this.table = table;
        this.observableMatcher = observableMatcher;
    }

    private Button createDialogButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    private Button createClearButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("X");
        return result;
    }

    private Control createContents(Composite cell) {
        this.inputText = new Text(cell, 16384);
        this.inputText.setEditable(true);
        this.inputText.setFont(cell.getFont());
        this.inputText.setBackground(Display.getDefault().getSystemColor(1));
        return this.inputText;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.layout = new DialogCellLayout();
        this.editor.setLayout((Layout)this.layout);
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.clearButton = this.createClearButton(this.editor);
        this.clearButton.setFont(font);
        this.dialogButton = this.createDialogButton(this.editor);
        this.dialogButton.setFont(font);
        this.dialogButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ModelElementCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.dialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object newValue;
                TableItem selection = ModelElementCellEditor.this.table.getSelection()[0];
                MatcherConfiguration conf = (MatcherConfiguration)selection.getData();
                if (!ModelElementCellEditor.this.tableViewerUtil.isPrimitiveType(conf.getClazz()) && (newValue = ModelElementCellEditor.this.openDialogBox((Control)ModelElementCellEditor.this.editor, conf.getClazz())) != null) {
                    boolean newValidState = ModelElementCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        ModelElementCellEditor.this.markDirty();
                        ModelElementCellEditor.this.doSetValue(newValue);
                        conf.setFilter(newValue);
                        ModelElementCellEditor.this.observableMatcher.setFilter(ModelElementCellEditor.this.getFilter(ModelElementCellEditor.this.table));
                    } else {
                        ModelElementCellEditor.this.setErrorMessage(MessageFormat.format(ModelElementCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    ModelElementCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selection = ModelElementCellEditor.this.table.getSelection()[0];
                MatcherConfiguration conf = (MatcherConfiguration)selection.getData();
                ModelElementCellEditor.this.inputText.setText("");
                ModelElementCellEditor.this.value = "";
                conf.setFilter("");
                ModelElementCellEditor.this.observableMatcher.setFilter(ModelElementCellEditor.this.getFilter(ModelElementCellEditor.this.table));
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    public void deactivate() {
        if (this.inputText != null && !this.inputText.isDisposed()) {
            this.inputText.removeKeyListener(this.getTextKeyListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        TableItem selection = this.table.getSelection()[0];
        MatcherConfiguration conf = (MatcherConfiguration)selection.getData();
        if (!this.tableViewerUtil.isPrimitiveType(conf.getClazz())) {
            this.inputText.setEditable(false);
        } else {
            this.inputText.setEditable(true);
        }
        this.inputText.setFocus();
        this.inputText.addKeyListener(this.getTextKeyListener());
        this.inputText.setBackground(Display.getDefault().getSystemColor(1));
    }

    private KeyListener getTextKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    String newValue = ModelElementCellEditor.this.inputText.getText();
                    TableItem ti = ModelElementCellEditor.this.table.getSelection()[0];
                    MatcherConfiguration conf = (MatcherConfiguration)ti.getData();
                    if (ModelElementCellEditor.this.tableViewerUtil.isValidValue(conf.getClazz(), newValue)) {
                        ModelElementCellEditor.this.inputText.setBackground(Display.getDefault().getSystemColor(1));
                        conf.setFilter(ModelElementCellEditor.this.inputText.getText());
                        ModelElementCellEditor.this.value = ModelElementCellEditor.this.inputText.getText();
                        ModelElementCellEditor.this.observableMatcher.setFilter(ModelElementCellEditor.this.getFilter(ModelElementCellEditor.this.table));
                    } else {
                        ModelElementCellEditor.this.inputText.setBackground(Display.getDefault().getSystemColor(3));
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            };
        }
        return this.keyListener;
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected Text getDefaultText() {
        return this.inputText;
    }

    protected Object openDialogBox(Control cellEditorWindow, String restriction) {
        ElementListSelectionDialog listDialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new ModelElementListDialogLabelProvider());
        listDialog.setTitle("Model element selection");
        listDialog.setMessage("Select a model element (* = any string, ? = any char):");
        Object[] input = this.getElements(this.root, restriction);
        listDialog.setElements(input);
        listDialog.open();
        Object[] result = listDialog.getResult();
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    protected void updateContents(Object value) {
        if (this.inputText == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.inputText.setText(text);
    }

    private Object[] getFilter(Table table) {
        Object[] result = new Object[table.getItems().length];
        int i = 0;
        for (String parameterName : this.observableMatcher.getMatcher().getParameterNames()) {
            result[i++] = this.getParameterFilter(table, parameterName);
        }
        return result;
    }

    private Object getParameterFilter(Table table, String parameterName) {
        int i = 0;
        while (i < table.getItems().length) {
            MatcherConfiguration mc = (MatcherConfiguration)table.getItem(i).getData();
            if (mc.getParameterName().equals(parameterName)) {
                return this.tableViewerUtil.createValue(mc.getClazz(), mc.getFilter());
            }
            ++i;
        }
        return null;
    }

    private Object[] getElements(Object inputElement, String restrictionFqn) {
        ArrayList<EObject> result;
        block5: {
            EObject obj;
            TreeIterator iterator;
            block6: {
                block4: {
                    result = new ArrayList<EObject>();
                    iterator = null;
                    obj = null;
                    if (!(this.root instanceof EObject)) break block4;
                    iterator = ((EObject)this.root).eAllContents();
                    while (iterator.hasNext()) {
                        obj = (EObject)iterator.next();
                        if (!this.isOfType(obj.getClass(), restrictionFqn)) continue;
                        result.add(obj);
                    }
                    break block5;
                }
                if (!(this.root instanceof Resource)) break block6;
                iterator = ((Resource)this.root).getAllContents();
                while (iterator.hasNext()) {
                    obj = (EObject)iterator.next();
                    if (!this.isOfType(obj.getClass(), restrictionFqn)) continue;
                    result.add(obj);
                }
                break block5;
            }
            if (!(this.root instanceof ResourceSet)) break block5;
            for (Resource res : ((ResourceSet)this.root).getResources()) {
                iterator = res.getAllContents();
                while (iterator.hasNext()) {
                    obj = (EObject)iterator.next();
                    if (!this.isOfType(obj.getClass(), restrictionFqn)) continue;
                    result.add(obj);
                }
            }
        }
        return result.toArray();
    }

    private boolean isOfType(Class<?> clazz, String restrictionFqn) {
        List<String> classes = this.collectAllInterfaces(clazz);
        classes.add("java.lang.Object");
        return classes.contains(restrictionFqn);
    }

    private List<String> collectAllInterfaces(Class clazz) {
        Class<?>[] interfaces;
        ArrayList<String> result = new ArrayList<String>();
        Class<?>[] classArray = interfaces = clazz.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            result.add(i.getName());
            result.addAll(this.collectAllInterfaces(i));
            ++n2;
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        if (this.layout != null) {
            this.layout = null;
        }
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point dialogButtonSize = ModelElementCellEditor.this.dialogButton.computeSize(-1, -1, force);
            Point clearButtonSize = ModelElementCellEditor.this.clearButton.computeSize(-1, -1, force);
            if (ModelElementCellEditor.this.contents != null) {
                ModelElementCellEditor.this.contents.setBounds(0, 0, bounds.width - dialogButtonSize.x - clearButtonSize.x, bounds.height);
            }
            ModelElementCellEditor.this.clearButton.setBounds(bounds.width - dialogButtonSize.x - clearButtonSize.x, 0, clearButtonSize.x, bounds.height);
            ModelElementCellEditor.this.dialogButton.setBounds(bounds.width - dialogButtonSize.x, 0, dialogButtonSize.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ModelElementCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = ModelElementCellEditor.this.dialogButton.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

