/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.adapters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.incquery.runtime.api.IModelConnector;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ModelConnectorTreeViewerKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.ModelEditorPartListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class EMFModelConnector
implements IModelConnector {
    protected IEditorPart editorPart;
    protected ILog logger = IncQueryGUIPlugin.getDefault().getLog();
    private ModelConnectorTreeViewerKey key;
    protected IWorkbenchPage workbenchPage;
    private ModelEditorPartListener modelEditorPartListener;

    public EMFModelConnector(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public void loadModel(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        Notifier notifier = this.getNotifier(modelConnectorTypeEnum);
        if (notifier != null) {
            this.key = new ModelConnectorTreeViewerKey(this.editorPart, notifier);
            this.workbenchPage = this.key.getEditorPart().getSite().getPage();
            this.modelEditorPartListener = new ModelEditorPartListener(this);
            this.workbenchPage.addPartListener((IPartListener)this.modelEditorPartListener);
            if (QueryExplorer.getInstance() != null) {
                QueryExplorer.getInstance().getMatcherTreeViewerRoot().addPatternMatcherRoot(this.key);
            }
        }
    }

    public void unloadModel() {
        this.workbenchPage.removePartListener((IPartListener)this.modelEditorPartListener);
        if (QueryExplorer.getInstance() != null) {
            QueryExplorer.getInstance().getMatcherTreeViewerRoot().removePatternMatcherRoot(this.key);
        }
    }

    public void showLocation(Object[] locationObjects) {
        TreeSelection preparedSelection = this.prepareSelection(locationObjects);
        this.navigateToElements(this.key.getEditorPart(), (IStructuredSelection)preparedSelection);
        this.workbenchPage.bringToTop((IWorkbenchPart)this.key.getEditorPart());
        this.reflectiveSetSelection(this.key.getEditorPart(), (IStructuredSelection)preparedSelection);
    }

    public ModelConnectorTreeViewerKey getKey() {
        return this.key;
    }

    public Notifier getNotifier(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        ISelectionProvider selectionProvider;
        ResourceSet result = null;
        if (IModelConnectorTypeEnum.RESOURCESET.equals((Object)modelConnectorTypeEnum)) {
            if (this.editorPart instanceof IEditingDomainProvider) {
                IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)this.editorPart;
                result = editingDomainProvider.getEditingDomain().getResourceSet();
            }
        } else if (IModelConnectorTypeEnum.RESOURCE.equals((Object)modelConnectorTypeEnum) && this.editorPart instanceof ISelectionProvider && (selectionProvider = (ISelectionProvider)this.editorPart).getSelection() instanceof TreeSelection) {
            Object object = ((TreeSelection)selectionProvider.getSelection()).getFirstElement();
            if (object instanceof Resource) {
                result = (Resource)object;
            } else if (object instanceof EObject) {
                result = ((EObject)object).eResource();
            }
        }
        return result;
    }

    private void reflectiveSetSelection(IEditorPart editorPart, IStructuredSelection preparedSelection) {
        try {
            Method m = editorPart.getClass().getMethod("setSelectionToViewer", Collection.class);
            if (m != null) {
                m.invoke((Object)editorPart, preparedSelection.toList());
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "setSelectionToViewer method not found", (Throwable)e));
        }
        catch (Exception e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "setSelectionToViewer call failed", (Throwable)e));
        }
    }

    protected TreeSelection prepareSelection(Object[] locationObjects) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        Object[] objectArray = locationObjects;
        int n = locationObjects.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path;
            Object o = objectArray[n2];
            if (o instanceof EObject && (path = this.createTreePath(this.key.getEditorPart(), (EObject)o)) != null) {
                paths.add(path);
            }
            ++n2;
        }
        if (paths.size() > 0) {
            return new TreeSelection(paths.toArray(new TreePath[1]));
        }
        return new TreeSelection();
    }

    protected void navigateToElements(IEditorPart editorPart, IStructuredSelection selection) {
        ISelectionProvider selectionProvider = editorPart.getSite().getSelectionProvider();
        selectionProvider.setSelection((ISelection)selection);
    }

    protected TreePath createTreePath(IEditorPart editorPart, EObject obj) {
        LinkedList<EObject> nodes = new LinkedList<EObject>();
        nodes.add(obj);
        EObject tmp = obj.eContainer();
        while (tmp != null) {
            nodes.add(0, tmp);
            tmp = tmp.eContainer();
        }
        return new TreePath(nodes.toArray());
    }
}

