/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.util;

import com.google.common.base.Preconditions;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class IncQueryLoggingUtil {
    private static Logger externalLogger;
    private static Logger defaultRuntimeLogger;

    public static void setExternalLogger(Logger externalLogger) {
        Preconditions.checkArgument((externalLogger != null ? 1 : 0) != 0, (Object)"Must not set up null logger");
        IncQueryLoggingUtil.externalLogger = externalLogger;
    }

    public static Logger getDefaultLogger() {
        Logger parentLogger;
        if (defaultRuntimeLogger == null && (defaultRuntimeLogger = (parentLogger = externalLogger) == null ? Logger.getLogger(IncQueryLoggingUtil.class) : Logger.getLogger((String)(String.valueOf(parentLogger.getName()) + ".runtime"))) == null) {
            throw new AssertionError((Object)"Configuration error: unable to create default IncQuery runtime logger.");
        }
        return defaultRuntimeLogger;
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger((String)(String.valueOf(IncQueryLoggingUtil.getDefaultLogger().getName()) + "." + clazz.getName()));
    }

    public static void setupConsoleAppenderForDefaultLogger() {
        Logger logger = IncQueryLoggingUtil.getDefaultLogger();
        logger.setAdditivity(false);
        logger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
    }
}

