/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.context.surrogate.SurrogateQueryRegistry;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public class SurrogateQueryRewriter
extends PDisjunctionRewriter {
    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet replacedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body){

                @Override
                protected void copyTypeConstraint(TypeConstraint typeConstraint) {
                    Object[] mappedVariables = this.extractMappedVariables(typeConstraint);
                    FlatTuple variablesTuple = new FlatTuple(mappedVariables);
                    IInputKey supplierKey = (IInputKey)typeConstraint.getSupplierKey();
                    if (SurrogateQueryRegistry.instance().hasSurrogateQueryFQN(supplierKey)) {
                        PQuery surrogateQuery = SurrogateQueryRegistry.instance().getSurrogateQuery(supplierKey);
                        if (surrogateQuery == null) {
                            throw new IllegalStateException(String.format("Surrogate query for feature %s not found", supplierKey.getPrettyPrintableName()));
                        }
                        new PositivePatternCall(this.getCopiedBody(), (Tuple)variablesTuple, surrogateQuery);
                    } else {
                        new TypeConstraint(this.getCopiedBody(), (Tuple)variablesTuple, supplierKey);
                    }
                }
            };
            PBody modifiedBody = copier.getCopiedBody();
            replacedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction(replacedBodies);
    }
}

