/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicenumerables;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.KeyedEnumerablePConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public class TypeConstraint
extends KeyedEnumerablePConstraint<IInputKey>
implements ITypeConstraint {
    private TypeJudgement equivalentJudgement;

    public TypeConstraint(PBody pSystem, Tuple variablesTuple, IInputKey inputKey) {
        super(pSystem, variablesTuple, inputKey);
        this.equivalentJudgement = new TypeJudgement(inputKey, variablesTuple);
        if (!inputKey.isEnumerable()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " applicable for enumerable input keys only; received instead " + inputKey);
        }
        if (variablesTuple.getSize() != inputKey.getArity()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " applied for variable tuple " + variablesTuple + " having wrong arity for input key " + inputKey);
        }
    }

    @Override
    protected String keyToString() {
        return ((IInputKey)this.supplierKey).getPrettyPrintableName();
    }

    @Override
    public TypeJudgement getEquivalentJudgement() {
        return this.equivalentJudgement;
    }

    @Override
    public Set<TypeJudgement> getImpliedJudgements(IQueryMetaContext context) {
        return Collections.singleton(this.equivalentJudgement);
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
        return ITypeConstraint.TypeConstraintUtil.getFunctionalDependencies(context, (IInputKey)this.supplierKey, this.variablesTuple);
    }
}

