/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api.resolver;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictSet;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictSetUpdater;
import org.eclipse.incquery.runtime.evm.notification.IActivationNotificationListener;

public class ScopedConflictSet
implements ConflictSet {
    private final ChangeableConflictSet changeableConflictSet;
    private final RuleBase ruleBase;
    private final Multimap<RuleSpecification<?>, EventFilter<?>> specificationFilters;
    public IActivationNotificationListener listener;

    public ScopedConflictSet(RuleBase ruleBase, ConflictResolver conflictResolver, Multimap<RuleSpecification<?>, EventFilter<?>> specificationFilters) {
        this.ruleBase = ruleBase;
        this.changeableConflictSet = conflictResolver.createConflictSet();
        this.specificationFilters = ImmutableMultimap.copyOf(specificationFilters);
        this.listener = new ConflictSetUpdater(this.changeableConflictSet);
        for (Map.Entry entry : specificationFilters.entries()) {
            RuleSpecification ruleSpecification = (RuleSpecification)entry.getKey();
            this.registerListenerFromInstance(ruleSpecification, (EventFilter)entry.getValue());
        }
    }

    public Multimap<RuleSpecification<?>, EventFilter<?>> getSpecificationFilters() {
        return this.specificationFilters;
    }

    protected IActivationNotificationListener getListener() {
        return this.listener;
    }

    public void dispose() {
        for (Map.Entry entry : this.specificationFilters.entries()) {
            RuleSpecification ruleSpecification = (RuleSpecification)entry.getKey();
            this.unregisterListenerFromInstance(ruleSpecification, (EventFilter)entry.getValue());
        }
    }

    private <EventAtom> void unregisterListenerFromInstance(RuleSpecification<EventAtom> ruleSpecification, EventFilter<?> eventFilter) {
        RuleInstance<EventAtom> instance = this.ruleBase.getInstance(ruleSpecification, this.toTypedFilter(ruleSpecification, eventFilter));
        if (instance != null) {
            instance.removeActivationNotificationListener(this.listener);
        }
    }

    private <EventAtom> void registerListenerFromInstance(RuleSpecification<EventAtom> ruleSpecification, EventFilter<?> eventFilter) {
        RuleInstance<EventAtom> instance = this.ruleBase.getInstance(ruleSpecification, this.toTypedFilter(ruleSpecification, eventFilter));
        if (instance != null) {
            instance.addActivationNotificationListener(this.listener, true);
        }
    }

    private <EventAtom> EventFilter<? super EventAtom> toTypedFilter(RuleSpecification<EventAtom> ruleSpecification, EventFilter<?> eventFilter) {
        return eventFilter;
    }

    @Override
    public Activation<?> getNextActivation() {
        return this.changeableConflictSet.getNextActivation();
    }

    @Override
    public Set<Activation<?>> getNextActivations() {
        return this.changeableConflictSet.getNextActivations();
    }

    @Override
    public Set<Activation<?>> getConflictingActivations() {
        return this.changeableConflictSet.getConflictingActivations();
    }

    @Override
    public ConflictResolver getConflictResolver() {
        return this.changeableConflictSet.getConflictResolver();
    }
}

