/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.api.resolver.ChangeableConflictSet;

public class Executor {
    private RuleBase ruleBase;
    private Context context;
    private boolean scheduling = false;
    private final String startMessage = "Executing started in " + this;
    private final String reentrantMessage = "Reentrant schedule call ignored in " + this;
    private final String endMessage = "Executing ended in " + this;

    public Executor(EventRealm eventRealm) {
        this(eventRealm, Context.create());
    }

    public Executor(EventRealm eventRealm, Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"Cannot create trigger engine with null context!");
        this.ruleBase = new RuleBase(eventRealm);
    }

    protected void schedule() {
        if (!this.startScheduling()) {
            return;
        }
        Activation<?> nextActivation = null;
        ChangeableConflictSet conflictSet = this.ruleBase.getAgenda().getConflictSet();
        while ((nextActivation = conflictSet.getNextActivation()) != null) {
            this.ruleBase.getLogger().debug((Object)("Executing: " + nextActivation + " in " + this));
            nextActivation.fire(this.context);
        }
        this.endScheduling();
    }

    protected synchronized boolean startScheduling() {
        if (this.scheduling) {
            this.ruleBase.getLogger().debug((Object)this.reentrantMessage);
            return false;
        }
        this.scheduling = true;
        this.ruleBase.getLogger().debug((Object)this.startMessage);
        return true;
    }

    protected synchronized void endScheduling() {
        this.ruleBase.getLogger().debug((Object)this.endMessage);
        this.scheduling = false;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public Context getContext() {
        return this.context;
    }

    protected void dispose() {
        this.ruleBase.dispose();
    }
}

