/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.comprehension;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.comprehension.WellbehavingDerivedFeatureRegistry;

public class EMFModelComprehension {
    public static boolean untraversableDirectly(EStructuralFeature feature) {
        boolean suspect;
        boolean bl = suspect = feature.isDerived() || feature.isVolatile() || feature instanceof EReference && ((EReference)feature).isContainer();
        if (suspect) {
            suspect = !WellbehavingDerivedFeatureRegistry.isWellbehavingFeature(feature);
        }
        return suspect;
    }

    public static boolean representable(EStructuralFeature feature) {
        EReference reference;
        if (!EMFModelComprehension.untraversableDirectly(feature)) {
            return true;
        }
        if (feature instanceof EReference && (reference = (EReference)feature).isContainer() && EMFModelComprehension.representable((EStructuralFeature)reference.getEOpposite())) {
            return true;
        }
        boolean isMixed = "mixed".equals(EcoreUtil.getAnnotation((EModelElement)feature.getEContainingClass(), (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"kind"));
        if (isMixed) {
            return true;
        }
        String groupAnnotation = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"group");
        if (groupAnnotation != null && groupAnnotation.length() > 1 && '#' == groupAnnotation.charAt(0)) {
            String groupFeatureName = groupAnnotation.substring(1);
            EStructuralFeature groupFeature = feature.getEContainingClass().getEStructuralFeature(groupFeatureName);
            return EMFModelComprehension.representable(groupFeature);
        }
        return false;
    }

    public static void traverseModel(EMFVisitor visitor, Notifier source) {
        if (source == null) {
            return;
        }
        if (source instanceof EObject) {
            EMFModelComprehension.traverseObject(visitor, (EObject)source);
        } else if (source instanceof Resource) {
            EMFModelComprehension.traverseResource(visitor, (Resource)source);
        } else if (source instanceof ResourceSet) {
            EMFModelComprehension.traverseResourceSet(visitor, (ResourceSet)source);
        }
    }

    public static void traverseResourceSet(EMFVisitor visitor, ResourceSet source) {
        if (source == null) {
            return;
        }
        ArrayList resources = new ArrayList(source.getResources());
        for (Resource resource : resources) {
            EMFModelComprehension.traverseResource(visitor, resource);
        }
    }

    public static void traverseResource(EMFVisitor visitor, Resource source) {
        if (source == null) {
            return;
        }
        if (visitor.pruneSubtrees(source)) {
            return;
        }
        EList contents = source.getContents();
        for (EObject eObject : contents) {
            EMFModelComprehension.traverseObject(visitor, eObject);
        }
    }

    public static void traverseObject(EMFVisitor visitor, EObject source) {
        if (source == null) {
            return;
        }
        if (source.eIsProxy()) {
            if (visitor.forceProxyResolution()) {
                source = EcoreUtil.resolve((EObject)source, (EObject)source);
            }
            if (source.eIsProxy()) {
                visitor.visitUnresolvableProxyObject(source);
                return;
            }
        }
        if (visitor.preOrder()) {
            visitor.visitElement(source);
        }
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            boolean visitorPrunes;
            if (EMFModelComprehension.untraversableDirectly(feature) || (visitorPrunes = visitor.pruneFeature(feature)) && !EMFModelComprehension.unprunableFeature(visitor, source, feature)) continue;
            if (feature.isMany()) {
                Collection targets = (Collection)source.eGet(feature);
                for (Object target : targets) {
                    EMFModelComprehension.traverseFeatureInternal(visitor, source, feature, target, visitorPrunes);
                }
                continue;
            }
            Object target = source.eGet(feature);
            if (target == null) continue;
            EMFModelComprehension.traverseFeatureInternal(visitor, source, feature, target, visitorPrunes);
        }
        if (!visitor.preOrder()) {
            visitor.visitElement(source);
        }
    }

    private static boolean unprunableFeature(EMFVisitor visitor, EObject source, EStructuralFeature feature) {
        return feature instanceof EAttribute && EcorePackage.eINSTANCE.getEFeatureMapEntry().equals(((EAttribute)feature).getEAttributeType()) || feature instanceof EReference && ((EReference)feature).isContainment() && (!visitor.pruneSubtrees(source) || ((EReference)feature).getEOpposite() != null);
    }

    public static void traverseFeature(EMFVisitor visitor, EObject source, EStructuralFeature feature, Object target) {
        if (target == null) {
            return;
        }
        if (EMFModelComprehension.untraversableDirectly(feature)) {
            return;
        }
        EMFModelComprehension.traverseFeatureInternalSimple(visitor, source, feature, target);
    }

    private static void traverseFeatureInternalSimple(EMFVisitor visitor, EObject source, EStructuralFeature feature, Object target) {
        boolean visitorPrunes = visitor.pruneFeature(feature);
        if (visitorPrunes && !EMFModelComprehension.unprunableFeature(visitor, source, feature)) {
            return;
        }
        EMFModelComprehension.traverseFeatureInternal(visitor, source, feature, target, visitorPrunes);
    }

    private static void traverseFeatureInternal(EMFVisitor visitor, EObject source, EStructuralFeature feature, Object target, boolean visitorPrunes) {
        if (feature instanceof EAttribute) {
            if (!visitorPrunes) {
                visitor.visitAttribute(source, (EAttribute)feature, target);
            }
            if (target instanceof FeatureMap.Entry) {
                FeatureMap.Entry entry = (FeatureMap.Entry)target;
                EStructuralFeature emulated = entry.getEStructuralFeature();
                Object emulatedTarget = entry.getValue();
                EMFModelComprehension.emulateUntraversableFeature(visitor, source, emulated, emulatedTarget);
            }
        } else if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            EObject targetObject = (EObject)target;
            if (targetObject.eIsProxy()) {
                if (visitor.forceProxyResolution()) {
                    targetObject = EcoreUtil.resolve((EObject)targetObject, (EObject)source);
                }
                if (targetObject.eIsProxy()) {
                    visitor.visitUnresolvableProxyFeature(source, reference, targetObject);
                    return;
                }
            }
            if (reference.isContainment()) {
                EReference opposite;
                if (!visitorPrunes) {
                    visitor.visitInternalContainment(source, reference, targetObject);
                }
                if (!visitor.pruneSubtrees(source)) {
                    EMFModelComprehension.traverseObject(visitor, targetObject);
                }
                if ((opposite = reference.getEOpposite()) != null) {
                    EMFModelComprehension.emulateUntraversableFeature(visitor, targetObject, (EStructuralFeature)opposite, source);
                }
            } else if (!visitorPrunes) {
                visitor.visitNonContainmentReference(source, reference, targetObject);
            }
        }
    }

    private static void emulateUntraversableFeature(EMFVisitor visitor, EObject source, EStructuralFeature emulated, Object target) {
        if (EMFModelComprehension.untraversableDirectly(emulated)) {
            EMFModelComprehension.traverseFeatureInternalSimple(visitor, source, emulated, target);
        }
    }
}

