package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.ProtocolTransitionReferredQuerySpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ProtocolTransition;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.protocolTransitionReferred pattern,
 * to be used in conjunction with {@link ProtocolTransitionReferredMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see ProtocolTransitionReferredMatcher
 * @see ProtocolTransitionReferredProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class ProtocolTransitionReferredMatch extends BasePatternMatch {
  private ProtocolTransition fSelf;
  
  private Operation fOperation;
  
  private static List<String> parameterNames = makeImmutableList("self", "operation");
  
  private ProtocolTransitionReferredMatch(final ProtocolTransition pSelf, final Operation pOperation) {
    this.fSelf = pSelf;
    this.fOperation = pOperation;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("self".equals(parameterName)) return this.fSelf;
    if ("operation".equals(parameterName)) return this.fOperation;
    return null;
  }
  
  public ProtocolTransition getSelf() {
    return this.fSelf;
  }
  
  public Operation getOperation() {
    return this.fOperation;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("self".equals(parameterName) ) {
    	this.fSelf = (org.eclipse.uml2.uml.ProtocolTransition) newValue;
    	return true;
    }
    if ("operation".equals(parameterName) ) {
    	this.fOperation = (org.eclipse.uml2.uml.Operation) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSelf(final ProtocolTransition pSelf) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSelf = pSelf;
  }
  
  public void setOperation(final Operation pOperation) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fOperation = pOperation;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.protocolTransitionReferred";
  }
  
  @Override
  public List<String> parameterNames() {
    return ProtocolTransitionReferredMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSelf, fOperation};
  }
  
  @Override
  public ProtocolTransitionReferredMatch toImmutable() {
    return isMutable() ? newMatch(fSelf, fOperation) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"self\"=" + prettyPrintValue(fSelf) + ", ");
    
    result.append("\"operation\"=" + prettyPrintValue(fOperation)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSelf == null) ? 0 : fSelf.hashCode());
    result = prime * result + ((fOperation == null) ? 0 : fOperation.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof ProtocolTransitionReferredMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    ProtocolTransitionReferredMatch other = (ProtocolTransitionReferredMatch) obj;
    if (fSelf == null) {if (other.fSelf != null) return false;}
    else if (!fSelf.equals(other.fSelf)) return false;
    if (fOperation == null) {if (other.fOperation != null) return false;}
    else if (!fOperation.equals(other.fOperation)) return false;
    return true;
  }
  
  @Override
  public ProtocolTransitionReferredQuerySpecification specification() {
    try {
    	return ProtocolTransitionReferredQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static ProtocolTransitionReferredMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pOperation the fixed value of pattern parameter operation, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static ProtocolTransitionReferredMatch newMutableMatch(final ProtocolTransition pSelf, final Operation pOperation) {
    return new Mutable(pSelf, pOperation);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pOperation the fixed value of pattern parameter operation, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static ProtocolTransitionReferredMatch newMatch(final ProtocolTransition pSelf, final Operation pOperation) {
    return new Immutable(pSelf, pOperation);
  }
  
  private static final class Mutable extends ProtocolTransitionReferredMatch {
    Mutable(final ProtocolTransition pSelf, final Operation pOperation) {
      super(pSelf, pOperation);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends ProtocolTransitionReferredMatch {
    Immutable(final ProtocolTransition pSelf, final Operation pOperation) {
      super(pSelf, pOperation);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
