package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.ProtocolTransitionReferredMatch;
import org.eclipse.incquery.uml.derivedfeatures.ProtocolTransitionReferredMatcher;

/**
 * A pattern-specific query specification that can instantiate ProtocolTransitionReferredMatcher in a type-safe way.
 * 
 * @see ProtocolTransitionReferredMatcher
 * @see ProtocolTransitionReferredMatch
 * 
 */
@SuppressWarnings("all")
public final class ProtocolTransitionReferredQuerySpecification extends BaseGeneratedEMFQuerySpecification<ProtocolTransitionReferredMatcher> {
  private ProtocolTransitionReferredQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ProtocolTransitionReferredQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ProtocolTransitionReferredMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ProtocolTransitionReferredMatcher.on(engine);
  }
  
  @Override
  public ProtocolTransitionReferredMatch newEmptyMatch() {
    return ProtocolTransitionReferredMatch.newEmptyMatch();
  }
  
  @Override
  public ProtocolTransitionReferredMatch newMatch(final Object... parameters) {
    return ProtocolTransitionReferredMatch.newMatch((org.eclipse.uml2.uml.ProtocolTransition) parameters[0], (org.eclipse.uml2.uml.Operation) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static ProtocolTransitionReferredQuerySpecification INSTANCE = make();
    
    public static ProtocolTransitionReferredQuerySpecification make() {
      return new ProtocolTransitionReferredQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ProtocolTransitionReferredQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.protocolTransitionReferred";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","operation");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.ProtocolTransition"),new PParameter("operation", "org.eclipse.uml2.uml.Operation"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_operation = body.getOrCreateVariableByName("operation");
      	PVariable var_callEvent = body.getOrCreateVariableByName("callEvent");
      	PVariable var_temp2 = body.getOrCreateVariableByName("temp2");
      	PVariable var_trigger = body.getOrCreateVariableByName("trigger");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      	PVariable var_event = body.getOrCreateVariableByName("event");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	PVariable var_temp3 = body.getOrCreateVariableByName("temp3");
      	PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_operation, "operation")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ProtocolTransition")));
      	new TypeConstraint(body, new FlatTuple(var_operation), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Operation")));
      	new TypeConstraint(body, new FlatTuple(var_callEvent), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "CallEvent")));
      	new Equality(body, var_temp2, var_callEvent);
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Transition")));
      	new TypeConstraint(body, new FlatTuple(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Transition", "trigger")));
      	new Equality(body, var__virtual_0_, var_trigger);
      	new Equality(body, var_temp1, var_trigger);
      	new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Trigger")));
      	new TypeConstraint(body, new FlatTuple(var_temp1, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Trigger", "event")));
      	new Equality(body, var__virtual_1_, var_event);
      	new Equality(body, var_temp2, var_event);
      	new Equality(body, var_temp3, var_temp2);
      	new TypeConstraint(body, new FlatTuple(var_temp3), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "CallEvent")));
      	new TypeConstraint(body, new FlatTuple(var_temp3, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "CallEvent", "operation")));
      	new Equality(body, var__virtual_2_, var_operation);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "referred");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
