package org.eclipse.incquery.uml.derivedfeatures;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.AssociationEndTypeMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ConnectableElementEndMatcher;
import org.eclipse.incquery.uml.derivedfeatures.DeploymentTargetDeployedElementMatcher;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementClientDependencyMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ProtocolTransitionReferredMatcher;
import org.eclipse.incquery.uml.derivedfeatures.VertexIncomingMatcher;
import org.eclipse.incquery.uml.derivedfeatures.VertexOutgoingMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.AssociationEndTypeQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ConnectableElementEndQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.DeploymentTargetDeployedElementQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementClientDependencyQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ProtocolTransitionReferredQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.VertexIncomingQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.VertexOutgoingQuerySpecification;

/**
 * A pattern group formed of all patterns defined in Generated.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file Generated.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.incquery.uml.derivedfeatures, the group contains the definition of the following patterns: <ul>
 * <li>associationEndType</li>
 * <li>connectableElementEnd</li>
 * <li>deploymentTargetDeployedElement</li>
 * <li>namedElementClientDependency</li>
 * <li>protocolTransitionReferred</li>
 * <li>vertexIncoming</li>
 * <li>vertexOutgoing</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class Generated extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static Generated instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new Generated();
    }
    return INSTANCE;
  }
  
  private static Generated INSTANCE;
  
  private Generated() throws IncQueryException {
    querySpecifications.add(AssociationEndTypeQuerySpecification.instance());
    querySpecifications.add(ConnectableElementEndQuerySpecification.instance());
    querySpecifications.add(DeploymentTargetDeployedElementQuerySpecification.instance());
    querySpecifications.add(NamedElementClientDependencyQuerySpecification.instance());
    querySpecifications.add(ProtocolTransitionReferredQuerySpecification.instance());
    querySpecifications.add(VertexIncomingQuerySpecification.instance());
    querySpecifications.add(VertexOutgoingQuerySpecification.instance());
  }
  
  public AssociationEndTypeQuerySpecification getAssociationEndType() throws IncQueryException {
    return AssociationEndTypeQuerySpecification.instance();
  }
  
  public AssociationEndTypeMatcher getAssociationEndType(final IncQueryEngine engine) throws IncQueryException {
    return AssociationEndTypeMatcher.on(engine);
  }
  
  public ConnectableElementEndQuerySpecification getConnectableElementEnd() throws IncQueryException {
    return ConnectableElementEndQuerySpecification.instance();
  }
  
  public ConnectableElementEndMatcher getConnectableElementEnd(final IncQueryEngine engine) throws IncQueryException {
    return ConnectableElementEndMatcher.on(engine);
  }
  
  public DeploymentTargetDeployedElementQuerySpecification getDeploymentTargetDeployedElement() throws IncQueryException {
    return DeploymentTargetDeployedElementQuerySpecification.instance();
  }
  
  public DeploymentTargetDeployedElementMatcher getDeploymentTargetDeployedElement(final IncQueryEngine engine) throws IncQueryException {
    return DeploymentTargetDeployedElementMatcher.on(engine);
  }
  
  public NamedElementClientDependencyQuerySpecification getNamedElementClientDependency() throws IncQueryException {
    return NamedElementClientDependencyQuerySpecification.instance();
  }
  
  public NamedElementClientDependencyMatcher getNamedElementClientDependency(final IncQueryEngine engine) throws IncQueryException {
    return NamedElementClientDependencyMatcher.on(engine);
  }
  
  public ProtocolTransitionReferredQuerySpecification getProtocolTransitionReferred() throws IncQueryException {
    return ProtocolTransitionReferredQuerySpecification.instance();
  }
  
  public ProtocolTransitionReferredMatcher getProtocolTransitionReferred(final IncQueryEngine engine) throws IncQueryException {
    return ProtocolTransitionReferredMatcher.on(engine);
  }
  
  public VertexIncomingQuerySpecification getVertexIncoming() throws IncQueryException {
    return VertexIncomingQuerySpecification.instance();
  }
  
  public VertexIncomingMatcher getVertexIncoming(final IncQueryEngine engine) throws IncQueryException {
    return VertexIncomingMatcher.on(engine);
  }
  
  public VertexOutgoingQuerySpecification getVertexOutgoing() throws IncQueryException {
    return VertexOutgoingQuerySpecification.instance();
  }
  
  public VertexOutgoingMatcher getVertexOutgoing(final IncQueryEngine engine) throws IncQueryException {
    return VertexOutgoingMatcher.on(engine);
  }
}
