/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api.resolver;

import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.EventType;
import org.eclipse.incquery.runtime.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.incquery.runtime.evm.notification.IActivationNotificationListener;

public class ConflictSetUpdater
implements IActivationNotificationListener {
    private final ChangeableConflictSet changeableConflictSet;

    public ConflictSetUpdater(ChangeableConflictSet changeableConflictSet) {
        this.changeableConflictSet = changeableConflictSet;
    }

    @Override
    public void activationRemoved(Activation<?> activation, ActivationState oldState) {
        this.changeableConflictSet.removeActivation(activation);
    }

    @Override
    public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
        ActivationState state = activation.getState();
        this.refreshActivation(activation, state);
    }

    @Override
    public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
        ActivationState state = activation.getState();
        if (state.isInactive()) {
            this.changeableConflictSet.removeActivation(activation);
        } else {
            this.refreshActivation(activation, state);
        }
    }

    private void refreshActivation(Activation<?> activation, ActivationState state) {
        if (activation.isEnabled()) {
            this.changeableConflictSet.addActivation(activation);
        } else {
            this.changeableConflictSet.removeActivation(activation);
        }
    }
}

