/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;

public class UnionFindForVariables {
    private final List<Variable> inputVariables;
    private final int[] unionIdArray;

    public UnionFindForVariables(List<Variable> inputVariables) {
        this.inputVariables = new ArrayList<Variable>(inputVariables);
        this.unionIdArray = new int[inputVariables.size()];
        int i = 0;
        while (i < inputVariables.size()) {
            this.unionIdArray[i] = i;
            ++i;
        }
    }

    public boolean isSameUnion(Set<Variable> variables) {
        if (variables.size() > 1) {
            Variable current = null;
            for (Variable variable : variables) {
                if (current != null) {
                    if (!this.inputVariables.contains(variable) || this.isSameUnion(current, variable)) continue;
                    return false;
                }
                if (!this.inputVariables.contains(variable)) continue;
                current = variable;
            }
        }
        return true;
    }

    public void unite(Set<Variable> variables) {
        if (variables.size() > 1) {
            Variable current = null;
            for (Variable variable : variables) {
                if (current != null) {
                    if (!this.inputVariables.contains(variable)) continue;
                    this.unite(current, variable);
                    continue;
                }
                if (!this.inputVariables.contains(variable)) continue;
                current = variable;
            }
        }
    }

    public String getCurrentPartitionsFormatted() {
        String result = "";
        for (Set<Variable> unionSet : this.getPartitions()) {
            result = result.concat("[");
            for (Variable variable : unionSet) {
                result = result.concat(String.valueOf(variable.getName()) + " ");
            }
            result = result.concat("]");
        }
        return result;
    }

    public boolean isMoreThanOneUnion() {
        return this.getPartitions().size() > 1;
    }

    public void removeVariable(Variable variable) {
        if (this.inputVariables.contains(variable)) {
            int[] newUnionIdArray = new int[this.inputVariables.size() - 1];
            int indexOfVariable = this.inputVariables.indexOf(variable);
            int i = 0;
            while (i < this.inputVariables.size()) {
                if (i < indexOfVariable) {
                    newUnionIdArray[i] = this.unionIdArray[i];
                } else if (i != indexOfVariable && i > indexOfVariable) {
                    newUnionIdArray[i - 1] = this.unionIdArray[i];
                }
                ++i;
            }
            this.inputVariables.remove(variable);
        }
    }

    private boolean isSameUnion(Variable variable1, Variable variable2) {
        return this.unionIdArray[this.inputVariables.indexOf(variable1)] == this.unionIdArray[this.inputVariables.indexOf(variable2)];
    }

    private void unite(Variable variable1, Variable variable2) {
        if (!this.isSameUnion(variable1, variable2)) {
            int variable1ID = this.unionIdArray[this.inputVariables.indexOf(variable1)];
            int variable2ID = this.unionIdArray[this.inputVariables.indexOf(variable2)];
            int i = 0;
            while (i < this.unionIdArray.length) {
                if (this.unionIdArray[i] == variable1ID) {
                    this.unionIdArray[i] = variable2ID;
                }
                ++i;
            }
        }
    }

    private List<Set<Variable>> getPartitions() {
        ArrayList<Set<Variable>> resultList = new ArrayList<Set<Variable>>();
        HashSet<Integer> previousKeys = new HashSet<Integer>();
        for (Variable variableOuter : this.inputVariables) {
            int currentID = this.unionIdArray[this.inputVariables.indexOf(variableOuter)];
            if (previousKeys.contains(currentID)) continue;
            previousKeys.add(currentID);
            HashSet<Variable> currentSet = new HashSet<Variable>();
            for (Variable variableInner : this.inputVariables) {
                if (this.unionIdArray[this.inputVariables.indexOf(variableInner)] != currentID) continue;
                currentSet.add(variableInner);
            }
            resultList.add(currentSet);
        }
        return resultList;
    }

    public Set<Variable> getPartitionOfVariable(Variable var) {
        HashSet<Variable> set = new HashSet<Variable>();
        set.add(var);
        if (this.inputVariables.contains(var)) {
            int id = this.unionIdArray[this.inputVariables.indexOf(var)];
            for (Variable inner : this.inputVariables) {
                if (id != this.unionIdArray[this.inputVariables.indexOf(inner)]) continue;
                set.add(inner);
            }
        }
        return set;
    }
}

