/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.annotations.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationValidator;
import org.eclipse.incquery.patternlanguage.annotations.impl.ExtensionBasedPatternAnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.DoubleValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.IntValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ListValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;

public class ExtensionBasedPatternAnnotationValidator
implements IPatternAnnotationValidator {
    private final Iterable<ExtensionBasedPatternAnnotationParameter> definedAttributes;
    private final String name;
    private final String description;
    private final boolean deprecated;
    private final IPatternAnnotationAdditionalValidator validator;
    private static final ImmutableMap<String, Class<? extends ValueReference>> TYPEMAPPING = new ImmutableMap.Builder().put((Object)"int", IntValue.class).put((Object)"string", StringValue.class).put((Object)"double", DoubleValue.class).put((Object)"boolean", BoolValue.class).put((Object)"list", ListValue.class).put((Object)"variablereference", VariableValue.class).build();

    public ExtensionBasedPatternAnnotationValidator(String name, String description, boolean deprecated, Iterable<ExtensionBasedPatternAnnotationParameter> parameters, IPatternAnnotationAdditionalValidator validator) {
        this.name = name;
        this.description = description;
        this.deprecated = deprecated;
        this.definedAttributes = parameters;
        this.validator = validator;
    }

    @Override
    public Iterable<String> getAllAvailableParameterNames() {
        return Iterables.transform(this.definedAttributes, (Function)new AnnotationDefinitionParameterName());
    }

    private Iterable<String> getParameterNames(Annotation annotation) {
        return Iterables.transform(annotation.getParameters(), (Function)new AnnotationParameterName());
    }

    @Override
    public Iterable<String> getMissingMandatoryAttributes(Annotation annotation) {
        final Iterable<String> actualAttributeNames = this.getParameterNames(annotation);
        Iterable filteredParameters = Iterables.filter(this.definedAttributes, (Predicate)new Predicate<ExtensionBasedPatternAnnotationParameter>(){

            public boolean apply(ExtensionBasedPatternAnnotationParameter input) {
                Preconditions.checkNotNull((Object)input, (Object)"input");
                return input.isMandatory() && !Iterables.contains((Iterable)actualAttributeNames, (Object)input.getName());
            }
        });
        return Iterables.transform((Iterable)filteredParameters, (Function)new AnnotationDefinitionParameterName());
    }

    @Override
    public Iterable<AnnotationParameter> getUnknownAttributes(Annotation annotation) {
        final Iterable parameterNames = Iterables.transform(this.definedAttributes, (Function)new AnnotationDefinitionParameterName());
        return Iterables.filter(annotation.getParameters(), (Predicate)new Predicate<AnnotationParameter>(){

            public boolean apply(AnnotationParameter input) {
                Preconditions.checkNotNull((Object)input, (Object)"input");
                return !Iterables.contains((Iterable)parameterNames, (Object)input.getName());
            }
        });
    }

    @Override
    public Class<? extends ValueReference> getExpectedParameterType(AnnotationParameter parameter) {
        ExtensionBasedPatternAnnotationParameter expectedParameter = null;
        for (ExtensionBasedPatternAnnotationParameter p : this.definedAttributes) {
            if (!p.getName().equals(parameter.getName())) continue;
            expectedParameter = p;
        }
        if (expectedParameter == null) {
            return null;
        }
        String type = expectedParameter.getType();
        if (type != null && TYPEMAPPING.containsKey((Object)type)) {
            return (Class)TYPEMAPPING.get((Object)type);
        }
        return null;
    }

    @Override
    public String getAnnotationName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescription(String parameterName) {
        for (ExtensionBasedPatternAnnotationParameter param : this.definedAttributes) {
            if (!param.getName().equals(parameterName)) continue;
            return param.getDescription();
        }
        return "";
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isDeprecated(String parameterName) {
        for (ExtensionBasedPatternAnnotationParameter param : this.definedAttributes) {
            if (!param.getName().equals(parameterName)) continue;
            return param.isDeprecated();
        }
        return false;
    }

    @Override
    public IPatternAnnotationAdditionalValidator getAdditionalValidator() {
        return this.validator;
    }

    private static final class AnnotationDefinitionParameterName
    implements Function<ExtensionBasedPatternAnnotationParameter, String> {
        private AnnotationDefinitionParameterName() {
        }

        public String apply(ExtensionBasedPatternAnnotationParameter input) {
            Preconditions.checkNotNull((Object)input, (Object)"input");
            return input.getName();
        }
    }

    private static final class AnnotationParameterName
    implements Function<AnnotationParameter, String> {
        private AnnotationParameterName() {
        }

        public String apply(AnnotationParameter input) {
            Preconditions.checkNotNull((Object)input, (Object)"annotation");
            return input.getName();
        }
    }
}

