/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.validation;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidationDiagnostics;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.IDiagnosticConverter;

public class PatternSetValidator {
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private IDiagnosticConverter converter;

    public PatternSetValidationDiagnostics validate(Resource resource) {
        BasicDiagnostic chain = new BasicDiagnostic();
        PatternSetValidationDiagnostics collectedIssues = new PatternSetValidationDiagnostics();
        for (Resource.Diagnostic diag : resource.getErrors()) {
            if (!(diag instanceof AbstractDiagnostic)) continue;
            AbstractDiagnostic abstractDiagnostic = (AbstractDiagnostic)diag;
            this.converter.convertResourceDiagnostic((Resource.Diagnostic)abstractDiagnostic, Severity.ERROR, (IAcceptor)collectedIssues);
        }
        for (EObject obj : resource.getContents()) {
            this.diagnostician.validate(obj, (DiagnosticChain)chain);
        }
        for (Resource.Diagnostic diag : chain.getChildren()) {
            this.converter.convertValidatorDiagnostic((Diagnostic)diag, (IAcceptor)collectedIssues);
        }
        return collectedIssues;
    }

    public PatternSetValidationDiagnostics validate(Pattern pattern) {
        return this.validate((Collection<Pattern>)ImmutableList.of((Object)pattern));
    }

    public PatternSetValidationDiagnostics validateTransitively(Pattern pattern) {
        Set patternsToValidate = CorePatternLanguageHelper.getReferencedPatternsTransitive((Pattern)pattern);
        return this.validate(patternsToValidate);
    }

    public PatternSetValidationDiagnostics validate(Collection<Pattern> patternSet) {
        BasicDiagnostic chain = new BasicDiagnostic();
        PatternSetValidationDiagnostics collectedIssues = new PatternSetValidationDiagnostics();
        HashSet<Resource> containerResources = new HashSet<Resource>();
        for (Pattern pattern : patternSet) {
            Resource resource = pattern.eResource();
            if (resource == null) continue;
            containerResources.add(resource);
        }
        for (Resource resource : containerResources) {
            for (Resource.Diagnostic diag : resource.getErrors()) {
                AbstractDiagnostic abstractDiagnostic;
                URI uri;
                EObject obj;
                if (!(diag instanceof AbstractDiagnostic) || !EcoreUtil.isAncestor(patternSet, (EObject)(obj = resource.getEObject((uri = (abstractDiagnostic = (AbstractDiagnostic)diag).getUriToProblem()).fragment())))) continue;
                this.converter.convertResourceDiagnostic((Resource.Diagnostic)abstractDiagnostic, Severity.ERROR, (IAcceptor)collectedIssues);
            }
        }
        for (Pattern pattern : patternSet) {
            this.diagnostician.validate((EObject)pattern, (DiagnosticChain)chain);
        }
        for (Diagnostic diag : chain.getChildren()) {
            this.converter.convertValidatorDiagnostic(diag, (IAcceptor)collectedIssues);
        }
        return collectedIssues;
    }
}

