/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.emf.EcoreGenmodelRegistry;
import org.eclipse.incquery.patternlanguage.emf.scoping.IMetamodelProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class MetamodelProviderService
implements IMetamodelProvider {
    @Inject
    private Logger logger;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    private EcoreGenmodelRegistry genmodelRegistry;

    protected EcoreGenmodelRegistry getGenmodelRegistry() {
        if (this.genmodelRegistry == null) {
            this.genmodelRegistry = new EcoreGenmodelRegistry(this.logger);
        }
        return this.genmodelRegistry;
    }

    @Override
    public IScope getAllMetamodelObjects(IScope delegateScope, EObject context) {
        final Map<String, EPackage> metamodelMap = this.getMetamodelMap();
        HashSet<String> packageURIs = new HashSet<String>(metamodelMap.keySet());
        Iterable metamodels = Iterables.transform(packageURIs, (Function)new Function<String, IEObjectDescription>(){

            public IEObjectDescription apply(String from) {
                EPackage ePackage = (EPackage)metamodelMap.get(from);
                QualifiedName qualifiedName = MetamodelProviderService.this.qualifiedNameConverter.toQualifiedName(from);
                return EObjectDescription.create((QualifiedName)qualifiedName, (EObject)ePackage, Collections.singletonMap("nsURI", "true"));
            }
        });
        return new SimpleScope(IScope.NULLSCOPE, metamodels);
    }

    protected Map<String, EPackage> getMetamodelMap() {
        HashMap packageMap = Maps.newHashMap();
        HashSet nsURISet = Sets.newHashSet((Iterable)EPackage.Registry.INSTANCE.keySet());
        for (String key : nsURISet) {
            try {
                packageMap.put(key, EPackage.Registry.INSTANCE.getEPackage(key));
            }
            catch (Exception e) {
                this.logger.error((Object)String.format("Error loading EPackage %s: %s", key, e.getMessage()));
            }
        }
        return packageMap;
    }

    @Override
    public EPackage loadEPackage(String packageUri, ResourceSet resourceSet) {
        EPackage pack = this.lookUpEPackageInResourceSetContents(packageUri, resourceSet);
        if (pack != null) {
            return pack;
        }
        if (EPackage.Registry.INSTANCE.containsKey((Object)packageUri)) {
            return EPackage.Registry.INSTANCE.getEPackage(packageUri);
        }
        URI uri = null;
        try {
            uri = URI.createURI((String)packageUri);
            if (uri.fragment() == null) {
                Resource resource = resourceSet.getResource(uri, true);
                return (EPackage)resource.getContents().get(0);
            }
            return (EPackage)resourceSet.getEObject(uri, true);
        }
        catch (RuntimeException ex) {
            if (uri != null && uri.isPlatformResource()) {
                String platformString = uri.toPlatformString(true);
                URI platformPluginURI = URI.createPlatformPluginURI((String)platformString, (boolean)true);
                return this.loadEPackage(platformPluginURI.toString(), resourceSet);
            }
            this.logger.trace((Object)("Cannot load package with URI '" + packageUri + "'"), (Throwable)ex);
            return null;
        }
    }

    private EPackage lookUpEPackageInResourceSetContents(String packageUri, ResourceSet resourceSet) {
        HashSet<Resource> processedResources = new HashSet<Resource>();
        while (processedResources.size() != resourceSet.getResources().size()) {
            HashSet resources = new HashSet(resourceSet.getResources());
            resources.removeAll(processedResources);
            for (Resource resource : resources) {
                EPackage pkg = this.findEPackageInResource(packageUri, resource);
                if (pkg != null) {
                    return pkg;
                }
                processedResources.add(resource);
            }
        }
        return null;
    }

    private EPackage findEPackageInResource(String packageUri, Resource resource) {
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof EPackage) {
                if (!((EPackage)obj).getNsURI().equals(packageUri)) continue;
                return (EPackage)obj;
            }
            it.prune();
        }
        return null;
    }

    @Override
    public boolean isGeneratedCodeAvailable(EPackage ePackage, ResourceSet set) {
        return this.getGenmodelRegistry().findGenPackage(ePackage.getNsURI(), set) != null;
    }
}

