/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.scoping;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguageScopeHelper;
import org.eclipse.incquery.patternlanguage.emf.ResolutionException;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.scoping.IMetamodelProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

public class EMFPatternLanguageLinkingService
extends DefaultLinkingService {
    @Inject
    private Logger logger;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IMetamodelProvider metamodelProvider;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) {
        if (ref == EMFPatternLanguagePackage.eINSTANCE.getPackageImport_EPackage() && context instanceof PackageImport && node instanceof ILeafNode) {
            return this.getPackage((PackageImport)context, (ILeafNode)node);
        }
        if (ref == EMFPatternLanguagePackage.eINSTANCE.getEnumValue_Literal() && context instanceof EnumValue && node instanceof ILeafNode) {
            return this.getEnumLiteral((EnumValue)context, node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    private List<EObject> getEnumLiteral(EnumValue value, INode node) {
        try {
            EEnum type = null;
            if (value.getEnumeration() != null) {
                type = value.getEnumeration();
            } else if (value.eContainer() instanceof PathExpressionHead) {
                type = EMFPatternLanguageScopeHelper.calculateEnumerationType(this.getExpressionHead(value.eContainer()));
            } else {
                return Collections.emptyList();
            }
            String typename = ((ILeafNode)node).getText();
            EEnumLiteral literal = type.getEEnumLiteralByLiteral(typename);
            if (literal == null) {
                literal = type.getEEnumLiteral(typename);
            }
            if (literal != null) {
                return Collections.singletonList(literal);
            }
            return Collections.emptyList();
        }
        catch (ResolutionException resolutionException) {
            return Collections.emptyList();
        }
    }

    private PathExpressionHead getExpressionHead(EObject obj) {
        if (obj instanceof PathExpressionHead) {
            return (PathExpressionHead)obj;
        }
        if (obj.eContainer() != null) {
            return this.getExpressionHead(obj.eContainer());
        }
        return null;
    }

    private List<EObject> getPackage(PackageImport context, ILeafNode text) {
        String nsUri = this.getMetamodelNsURI(text);
        if (nsUri == null) {
            return Collections.emptyList();
        }
        EPackage pack = this.metamodelProvider.loadEPackage(nsUri, context.eResource().getResourceSet());
        if (pack != null) {
            return Collections.singletonList(pack);
        }
        return Collections.emptyList();
    }

    private String getMetamodelNsURI(ILeafNode text) {
        try {
            return (String)this.valueConverterService.toValue(text.getText(), this.getLinkingHelper().getRuleNameFrom(text.getGrammarElement()), (INode)text);
        }
        catch (ValueConverterException e) {
            this.logger.debug((Object)("Exception on leaf '" + text.getText() + "'"), (Throwable)e);
            return null;
        }
    }
}

