/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.XImportSection;

public class EMFPatternLanguageHelper {
    public static List<PackageImport> getAllPackageImports(PatternModel model) {
        return Lists.newArrayList(EMFPatternLanguageHelper.getPackageImportsIterable(model));
    }

    public static Iterable<PackageImport> getPackageImportsIterable(PatternModel model) {
        XImportSection imports = model.getImportPackages();
        if (imports == null) {
            return ImmutableList.of();
        }
        return Iterables.filter(imports.getPackageImport(), (Predicate)new Predicate<PackageImport>(){

            public boolean apply(PackageImport pImport) {
                return !pImport.eIsProxy();
            }
        });
    }
}

