/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.annotations;

import com.google.inject.Inject;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.emf.types.IEMFTypeProvider;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.validation.IIssueCallback;

public class AnnotationExpressionValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.incquery.patternlanguage.expression.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.incquery.patternlanguage.expression.general";
    public static final String UNKNOWN_VARIABLE_CODE = "org.eclipse.incquery.patternlanguage.expression.unknown_variable";
    public static final String UNKNOWN_ATTRIBUTE_CODE = "org.eclipse.incquery.patternlanguage.expression.unknown_attribute";
    public static final String UNDEFINED_NAME_CODE = "org.eclipse.incquery.patternlanguage.expression.undefined_name";
    @Inject
    private IEMFTypeProvider typeProvider;

    public void validateParameterString(String expression, Pattern pattern, ValueReference ref, IIssueCallback validator) {
        Variable parameter;
        if (expression.contains(".")) {
            validator.error("Expression must refer to a single parameter.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
        }
        if ((parameter = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)expression)) == null) {
            validator.error(String.format("Unknown parameter name %s", expression), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, UNKNOWN_VARIABLE_CODE, new String[0]);
            return;
        }
    }

    public void validateModelExpression(String expression, Pattern pattern, ValueReference ref, IIssueCallback validator) {
        String[] tokens = expression.split("\\.");
        if (expression.isEmpty() || tokens.length == 0) {
            validator.error("Expression must not be empty.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
            return;
        }
        Variable parameter = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)tokens[0]);
        if (parameter == null) {
            validator.error(String.format("Unknown parameter name %s", tokens[0]), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, UNKNOWN_VARIABLE_CODE, new String[0]);
            return;
        }
        EClassifier classifier = this.typeProvider.getClassifierForVariable(parameter);
        if (tokens.length == 1) {
            this.checkClassifierFeature(classifier, "name", ref, validator, false);
        } else if (tokens.length == 2) {
            String featureName = tokens[1];
            this.checkClassifierFeature(classifier, featureName, ref, validator, true);
        } else {
            validator.error("Only direct feature references are supported.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
        }
    }

    private void checkClassifierFeature(EClassifier classifier, String featureName, ValueReference ref, IIssueCallback validator, boolean userSpecified) {
        if (classifier instanceof EClass) {
            EClass classDef = (EClass)classifier;
            if (classDef.getEStructuralFeature(featureName) == null) {
                if (userSpecified) {
                    validator.error(String.format("Invalid feature type %s in EClass %s", featureName, classifier.getName()), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, UNKNOWN_ATTRIBUTE_CODE, new String[0]);
                } else {
                    validator.warning(String.format("EClass %s does not define a name attribute, so the string representation might be inconvinient to use. Perhaps a feature qualifier is missing?", classifier.getName()), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, UNKNOWN_ATTRIBUTE_CODE, new String[0]);
                }
            }
        } else if (classifier == null) {
            return;
        }
    }

    public void validateStringExpression(String expression, Pattern pattern, ValueReference ref, IIssueCallback validator) {
        StringTokenizer tokenizer = new StringTokenizer(expression, "$", true);
        if (expression.isEmpty() || tokenizer.countTokens() == 0) {
            validator.error("Expression must not be empty.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
            return;
        }
        boolean inExpression = false;
        boolean foundToken = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("$")) {
                if (inExpression && !foundToken) {
                    validator.error("Empty reference ($$) in message is not allowed.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
                }
                inExpression = !inExpression;
                continue;
            }
            if (!inExpression) continue;
            this.validateModelExpression(token, pattern, ref, validator);
            foundToken = true;
        }
        if (inExpression) {
            validator.error("Inconsistent model references - a $ character is missing.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
        }
    }
}

