/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.context.surrogate.SurrogateQueryRegistry;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class ExtensionBasedSurrogateQueryLoader {
    private static final String DUPLICATE_SURROGATE_QUERY = "Duplicate surrogate query definition %s for feature %s of EClass %s in package %s (FQN in map %s, contributing plug-ins %s, plug-in %s)";
    static final String EXTENSIONID = "org.eclipse.incquery.patternlanguage.emf.surrogatequeryemf";
    private Multimap<String, String> contributingPluginOfFeatureMap = HashMultimap.create();
    private Map<EStructuralFeature, PQuery> contributedSurrogateQueries;
    private static final ExtensionBasedSurrogateQueryLoader INSTANCE = new ExtensionBasedSurrogateQueryLoader();

    public static ExtensionBasedSurrogateQueryLoader instance() {
        return INSTANCE;
    }

    public void loadKnownSurrogateQueriesIntoRegistry() {
        Map<EStructuralFeature, PQuery> knownSurrogateQueryFQNs = this.getKnownSurrogateQueryFQNs();
        for (Map.Entry<EStructuralFeature, PQuery> entry : knownSurrogateQueryFQNs.entrySet()) {
            EStructuralFeatureInstancesKey inputKey = new EStructuralFeatureInstancesKey(entry.getKey());
            SurrogateQueryRegistry.instance().registerSurrogateQueryForFeature((IInputKey)inputKey, entry.getValue());
        }
    }

    public Map<EStructuralFeature, PQuery> getKnownSurrogateQueryFQNs() {
        if (this.contributedSurrogateQueries != null) {
            return this.contributedSurrogateQueries;
        }
        this.contributedSurrogateQueries = Maps.newHashMap();
        if (Platform.isRunning()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                this.processWellbehavingExtension(e);
                ++n2;
            }
        }
        return this.contributedSurrogateQueries;
    }

    private void processWellbehavingExtension(IConfigurationElement el) {
        try {
            String packageUri = el.getAttribute("package-nsUri");
            String className = el.getAttribute("class-name");
            String featureName = el.getAttribute("feature-name");
            PQuery surrogateQuery = (PQuery)el.createExecutableExtension("surrogate-query");
            String contributorName = el.getContributor().getName();
            StringBuilder featureIdBuilder = new StringBuilder();
            Preconditions.checkState((packageUri != null ? 1 : 0) != 0, (Object)"Package NsURI cannot be null in extension");
            Preconditions.checkState((className != null ? 1 : 0) != 0, (Object)"Class name cannot be null in extension");
            Preconditions.checkState((featureName != null ? 1 : 0) != 0, (Object)"Feature name cannot be null in extension");
            Preconditions.checkState((surrogateQuery != null ? 1 : 0) != 0, (Object)"Query FQN cannot be null in extension");
            EPackage pckg = EPackage.Registry.INSTANCE.getEPackage(packageUri);
            featureIdBuilder.append(packageUri);
            Preconditions.checkState((pckg != null ? 1 : 0) != 0, (String)"Package %s not found! (plug-in %s)", (Object[])new Object[]{packageUri, contributorName});
            EClassifier clsr = pckg.getEClassifier(className);
            featureIdBuilder.append("##").append(className);
            Preconditions.checkState((boolean)(clsr instanceof EClass), (String)"EClassifier %s does not exist in package %s! (plug-in %s)", (Object[])new Object[]{className, packageUri, contributorName});
            EClass cls = (EClass)clsr;
            EStructuralFeature feature = cls.getEStructuralFeature(featureName);
            featureIdBuilder.append("##").append(featureName);
            Preconditions.checkState((feature != null ? 1 : 0) != 0, (String)"Feature %s of EClass %s in package %s not found! (plug-in %s)", (Object[])new Object[]{featureName, className, packageUri, contributorName});
            PQuery fqnInMap = this.contributedSurrogateQueries.get(feature);
            if (fqnInMap != null) {
                String duplicateSurrogateFormatString = DUPLICATE_SURROGATE_QUERY;
                Collection contributorPlugins = this.contributingPluginOfFeatureMap.get((Object)featureIdBuilder.toString());
                String duplicateSurrogateMessage = String.format(duplicateSurrogateFormatString, surrogateQuery.getFullyQualifiedName(), featureName, className, packageUri, fqnInMap, contributorPlugins, contributorName);
                throw new IllegalStateException(duplicateSurrogateMessage);
            }
            this.contributedSurrogateQueries.put(feature, surrogateQuery);
            this.contributingPluginOfFeatureMap.put((Object)featureIdBuilder.toString(), (Object)contributorName);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(SurrogateQueryRegistry.class);
            logger.error((Object)"Surrogate query registration failed", (Throwable)e);
        }
    }
}

