/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.apiimpl.IncQueryEngineImpl;
import org.eclipse.incquery.runtime.internal.apiimpl.QueryResultWrapper;
import org.eclipse.incquery.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public abstract class BaseMatcher<Match extends IPatternMatch>
extends QueryResultWrapper
implements IncQueryMatcher<Match> {
    protected IncQueryEngine engine;
    protected IQuerySpecification<? extends BaseMatcher<Match>> querySpecification;
    private static Object[] fEmptyArray;

    public BaseMatcher(IncQueryEngine engine, IQuerySpecification<? extends BaseMatcher<Match>> querySpecification) throws IncQueryException {
        this.engine = engine;
        IncQueryEngineImpl engineImpl = (IncQueryEngineImpl)engine;
        this.querySpecification = querySpecification;
        try {
            this.querySpecification.getInternalQueryRepresentation().ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new IncQueryException(e);
        }
        this.backend = this.accessMatcher(engineImpl, querySpecification);
        engineImpl.reportMatcherInitialized(querySpecification, this);
    }

    private IQueryResultProvider accessMatcher(IncQueryEngineImpl engine, IQuerySpecification<? extends BaseMatcher<Match>> specification) throws IncQueryException {
        Preconditions.checkArgument((!specification.getInternalQueryRepresentation().getStatus().equals((Object)PQuery.PQueryStatus.ERROR) ? 1 : 0) != 0, (Object)("Cannot load erroneous query specification " + specification.getFullyQualifiedName()));
        Preconditions.checkArgument((!specification.getInternalQueryRepresentation().getStatus().equals((Object)PQuery.PQueryStatus.UNINITIALIZED) ? 1 : 0) != 0, (Object)("Cannot load uninitialized query specification " + specification.getFullyQualifiedName()));
        try {
            return engine.getResultProvider(specification);
        }
        catch (QueryProcessingException e) {
            throw new IncQueryException(e);
        }
    }

    protected abstract Match arrayToMatch(Object[] var1);

    protected abstract Match arrayToMatchMutable(Object[] var1);

    protected Object[] matchToArray(Match partialMatch) {
        return partialMatch.toArray();
    }

    protected abstract Match tupleToMatch(Tuple var1);

    protected Object[] emptyArray() {
        if (fEmptyArray == null) {
            fEmptyArray = new Object[this.getSpecification().getParameterNames().size()];
        }
        return fEmptyArray;
    }

    @Override
    public Integer getPositionOfParameter(String parameterName) {
        return this.getSpecification().getPositionOfParameter(parameterName);
    }

    @Override
    public List<String> getParameterNames() {
        return this.getSpecification().getParameterNames();
    }

    @Override
    public Collection<Match> getAllMatches() {
        return this.rawGetAllMatches(this.emptyArray());
    }

    protected Collection<Match> rawGetAllMatches(Object[] parameters) {
        Collection m = this.backend.getAllMatches(parameters);
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Tuple t : m) {
            matches.add(this.tupleToMatch(t));
        }
        return matches;
    }

    @Override
    public Collection<Match> getAllMatches(Match partialMatch) {
        return this.rawGetAllMatches(partialMatch.toArray());
    }

    @Override
    public Match getOneArbitraryMatch() {
        return this.rawGetOneArbitraryMatch(this.emptyArray());
    }

    protected Match rawGetOneArbitraryMatch(Object[] parameters) {
        Tuple t = this.backend.getOneArbitraryMatch(parameters);
        if (t != null) {
            return this.tupleToMatch(t);
        }
        return null;
    }

    @Override
    public Match getOneArbitraryMatch(Match partialMatch) {
        return this.rawGetOneArbitraryMatch(partialMatch.toArray());
    }

    protected boolean rawHasMatch(Object[] parameters) {
        return this.backend.countMatches(parameters) > 0;
    }

    @Override
    public boolean hasMatch(Match partialMatch) {
        return this.rawHasMatch(partialMatch.toArray());
    }

    @Override
    public int countMatches() {
        return this.rawCountMatches(this.emptyArray());
    }

    protected int rawCountMatches(Object[] parameters) {
        return this.backend.countMatches(parameters);
    }

    @Override
    public int countMatches(Match partialMatch) {
        return this.rawCountMatches(partialMatch.toArray());
    }

    protected void rawForEachMatch(Object[] parameters, IMatchProcessor<? super Match> processor) {
        Collection m = this.backend.getAllMatches(parameters);
        for (Tuple t : m) {
            processor.process(this.tupleToMatch(t));
        }
    }

    @Override
    public void forEachMatch(IMatchProcessor<? super Match> processor) {
        this.rawForEachMatch(this.emptyArray(), processor);
    }

    @Override
    public void forEachMatch(Match match, IMatchProcessor<? super Match> processor) {
        this.rawForEachMatch(match.toArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(IMatchProcessor<? super Match> processor) {
        return this.rawForOneArbitraryMatch(this.emptyArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(Match partialMatch, IMatchProcessor<? super Match> processor) {
        return this.rawForOneArbitraryMatch(partialMatch.toArray(), processor);
    }

    protected boolean rawForOneArbitraryMatch(Object[] parameters, IMatchProcessor<? super Match> processor) {
        Tuple t = this.backend.getOneArbitraryMatch(parameters);
        if (t != null) {
            processor.process(this.tupleToMatch(t));
            return true;
        }
        return false;
    }

    @Override
    public Match newEmptyMatch() {
        return this.arrayToMatchMutable(new Object[this.getParameterNames().size()]);
    }

    @Override
    public Match newMatch(Object ... parameters) {
        return this.arrayToMatch(parameters);
    }

    @Override
    public Set<Object> getAllValues(String parameterName) {
        return this.rawGetAllValues(this.getPositionOfParameter(parameterName), this.emptyArray());
    }

    @Override
    public Set<Object> getAllValues(String parameterName, Match partialMatch) {
        return this.rawGetAllValues(this.getPositionOfParameter(parameterName), partialMatch.toArray());
    }

    protected Set<Object> rawGetAllValues(int position, Object[] parameters) {
        if (position >= 0 && position < this.getParameterNames().size() && parameters.length == this.getParameterNames().size() && parameters[position] == null) {
            HashSet<Object> results = new HashSet<Object>();
            this.rawAccumulateAllValues(position, parameters, results);
            return results;
        }
        return null;
    }

    protected <T> void rawAccumulateAllValues(final int position, Object[] parameters, final Set<T> accumulator) {
        this.rawForEachMatch(parameters, new IMatchProcessor<Match>(){

            @Override
            public void process(Match match) {
                accumulator.add(match.get(position));
            }
        });
    }

    @Override
    public IncQueryEngine getEngine() {
        return this.engine;
    }

    @Override
    public IQuerySpecification<? extends BaseMatcher<Match>> getSpecification() {
        return this.querySpecification;
    }

    @Override
    public String getPatternName() {
        return this.querySpecification.getFullyQualifiedName();
    }
}

