/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.single;

import java.util.Collection;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.incquery.runtime.base.itc.graphimpl.Graph;
import org.eclipse.incquery.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.ITcObserver;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.tuple.Clearable;

public class TransitiveClosureNode
extends SingleInputNode
implements Clearable,
ITcObserver<Object> {
    private Graph<Object> graphDataSource = new Graph();
    private ITcDataSource<Object> transitiveClosureAlgorithm = new IncSCCAlg(this.graphDataSource);

    public TransitiveClosureNode(ReteContainer reteContainer) {
        super(reteContainer);
        this.transitiveClosureAlgorithm.attachObserver((ITcObserver)this);
        reteContainer.registerClearable(this);
    }

    public void reinitializeWith(Collection<Tuple> tuples) {
        this.clear();
        for (Tuple t : tuples) {
            this.graphDataSource.insertNode(t.get(0));
            this.graphDataSource.insertNode(t.get(1));
            this.graphDataSource.insertEdge(t.get(0), t.get(1));
        }
        this.transitiveClosureAlgorithm.attachObserver((ITcObserver)this);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (org.eclipse.incquery.runtime.base.itc.alg.misc.Tuple tuple : ((IncSCCAlg)this.transitiveClosureAlgorithm).getTcRelation()) {
            collector.add((Tuple)new FlatTuple(new Object[]{tuple.getSource(), tuple.getTarget()}));
        }
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        if (updateElement.getSize() == 2) {
            Object source = updateElement.get(0);
            Object target = updateElement.get(1);
            if (direction == Direction.INSERT) {
                this.graphDataSource.insertNode(source);
                this.graphDataSource.insertNode(target);
                this.graphDataSource.insertEdge(source, target);
            }
            if (direction == Direction.REVOKE) {
                this.graphDataSource.deleteEdge(source, target);
                if (((IncSCCAlg)this.transitiveClosureAlgorithm).isIsolated(source)) {
                    this.graphDataSource.deleteNode(source);
                }
                if (!source.equals(target) && ((IncSCCAlg)this.transitiveClosureAlgorithm).isIsolated(target)) {
                    this.graphDataSource.deleteNode(target);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.transitiveClosureAlgorithm.dispose();
        this.graphDataSource = new Graph();
        this.transitiveClosureAlgorithm = new IncSCCAlg(this.graphDataSource);
    }

    public void tupleInserted(Object source, Object target) {
        FlatTuple tuple = new FlatTuple(new Object[]{source, target});
        this.propagateUpdate(Direction.INSERT, (Tuple)tuple);
    }

    public void tupleDeleted(Object source, Object target) {
        FlatTuple tuple = new FlatTuple(new Object[]{source, target});
        this.propagateUpdate(Direction.REVOKE, (Tuple)tuple);
    }

    @Override
    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        super.propagateUpdate(direction, updateElement);
    }
}

