/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.tuple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;

public abstract class Tuple {
    protected int cachedHash;

    protected Tuple() {
    }

    public abstract int getSize();

    public abstract Object get(int var1);

    public Object[] getElements() {
        Object[] allElements = new Object[this.getSize()];
        int i = 0;
        while (i < allElements.length) {
            allElements[i] = this.get(i);
            ++i;
        }
        return allElements;
    }

    public <T> Set<T> getDistinctElements() {
        Object[] elements;
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            result.add(object);
            ++n2;
        }
        return result;
    }

    void calcHash() {
        this.cachedHash = 1;
        int i = 0;
        while (i < this.getSize()) {
            this.cachedHash *= 31;
            Object element = this.get(i);
            if (element != null) {
                this.cachedHash += element.hashCode();
            }
            ++i;
        }
    }

    public Map<Object, Integer> invertIndex() {
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        int i = 0;
        while (i < this.getSize()) {
            result.put(this.get(i), i);
            ++i;
        }
        return result;
    }

    public Map<Object, List<Integer>> invertIndexWithMupliplicity() {
        HashMap<Object, List<Integer>> result = new HashMap<Object, List<Integer>>();
        int i = 0;
        while (i < this.getSize()) {
            Object value = this.get(i);
            ArrayList<Integer> indices = (ArrayList<Integer>)result.get(value);
            if (indices == null) {
                indices = new ArrayList<Integer>();
                result.put(value, indices);
            }
            indices.add(i);
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)obj;
        if (this.cachedHash != other.cachedHash) {
            return false;
        }
        return this.internalEquals(other);
    }

    protected boolean internalEquals(Tuple other) {
        if (this.getSize() != other.getSize()) {
            return false;
        }
        int i = 0;
        while (i < this.getSize()) {
            Object ours = this.get(i);
            Object theirs = other.get(i);
            if (ours == null ? theirs != null : !ours.equals(theirs)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("T(");
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            s.append(o == null ? "null" : o.toString());
            s.append(';');
            ++n2;
        }
        s.append(')');
        return s.toString();
    }

    public Tuple replaceAll(Object obsolete, Object replacement) {
        Object[] oldElements = this.getElements();
        Object[] newElements = new Object[oldElements.length];
        int i = 0;
        while (i < oldElements.length) {
            newElements[i] = obsolete.equals(oldElements[i]) ? replacement : oldElements[i];
            ++i;
        }
        return new FlatTuple(newElements);
    }
}

