/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;

public class BinaryTransitiveClosureCheck
extends CheckOperation {
    private LocalSearchMatcher calledMatcher;
    private int sourcePosition;
    private int targetPosition;

    public BinaryTransitiveClosureCheck(LocalSearchMatcher calledMatcher, int sourcePosition, int targetPosition) {
        this.calledMatcher = calledMatcher;
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        Object targetValue = frame.get(this.targetPosition);
        LinkedHashSet sourcesToEvaluate = Sets.newLinkedHashSet();
        sourcesToEvaluate.add(frame.get(this.sourcePosition));
        HashSet sourceEvaluated = Sets.newHashSet();
        do {
            Object currentValue = sourcesToEvaluate.iterator().next();
            sourcesToEvaluate.remove(currentValue);
            MatchingFrame mappedFrame = this.calledMatcher.editableMatchingFrame();
            mappedFrame.setValue(0, currentValue);
            for (MatchingFrame match : this.calledMatcher.getAllMatches(mappedFrame)) {
                Object foundTarget = match.get(1);
                if (targetValue.equals(foundTarget)) {
                    return true;
                }
                if (sourceEvaluated.contains(foundTarget)) continue;
                sourcesToEvaluate.add(foundTarget);
            }
        } while (!sourcesToEvaluate.isEmpty());
        return false;
    }
}

