/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.MatchingKey;

public class MatchingTable
extends AbstractCollection<MatchingFrame> {
    private Map<MatchingKey, Collection<MatchingFrame>> matchings = new HashMap<MatchingKey, Collection<MatchingFrame>>();

    @Override
    public Iterator<MatchingFrame> iterator() {
        return new MatchingIterator();
    }

    @Override
    public int size() {
        return this.matchings.keySet().size();
    }

    public void put(MatchingKey key, MatchingFrame value) {
        Collection<MatchingFrame> coll = this.matchings.get(key);
        if (coll == null) {
            coll = new HashSet<MatchingFrame>();
            this.matchings.put(key, coll);
        }
        coll.add(value);
    }

    private final class MatchingIterator
    implements Iterator<MatchingFrame> {
        Iterator<Map.Entry<MatchingKey, Collection<MatchingFrame>>> iterator;

        private MatchingIterator() {
            this.iterator = MatchingTable.this.matchings.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatchingFrame next() {
            if (this.hasNext()) {
                Collection<MatchingFrame> frames = this.iterator.next().getValue();
                Iterator<MatchingFrame> frameIterator = frames.iterator();
                if (frameIterator.hasNext()) {
                    return frameIterator.next();
                }
                throw new NoSuchElementException();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

