/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.types;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.patternlanguage.emf.types.EMFPatternTypeProvider;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;

@Singleton
public class GenModelBasedTypeProvider
extends EMFPatternTypeProvider {
    @Inject
    private IEiqGenmodelProvider genModelProvider;

    protected String getClassNameForEClassifier(EClassifier classifier, EObject context) {
        GenPackage genPackage;
        EPackage ePackage;
        String className = super.getClassNameForEClassifier(classifier, context);
        if (Strings.isNullOrEmpty((String)className) && classifier != null && (ePackage = classifier.getEPackage()) != null && (genPackage = this.genModelProvider.findGenPackage(context, ePackage)) != null) {
            className = this.resolveTypeReference(genPackage, classifier);
        }
        return className;
    }

    private String resolveTypeReference(GenPackage genPackage, EClassifier classifier) {
        GenClassifier genClassifier = this.findGenClassifier(genPackage, classifier);
        String className = null;
        className = !Strings.isNullOrEmpty((String)classifier.getInstanceClassName()) ? classifier.getInstanceClassName() : (genClassifier instanceof GenClass ? ((GenClass)genClassifier).getQualifiedInterfaceName() : (genClassifier instanceof GenEnum ? ((GenEnum)genClassifier).getQualifiedInstanceClassName() : String.valueOf(genPackage.getGenModel().getModelPluginPackageName()) + "." + classifier.getName()));
        return className;
    }

    private GenClassifier findGenClassifier(GenPackage genPackage, EClassifier classifier) {
        for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
            if (!classifier.equals(genClassifier.getEcoreClassifier())) continue;
            return genClassifier;
        }
        return null;
    }
}

