/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewmodel.traceablilty.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewmodel.traceability.patterns.util.TraceQuerySpecification;
import org.eclipse.incquery.viewmodel.traceablilty.generic.GenericReferencedPQuery;

public class GenericTracedPQuery
extends GenericReferencedPQuery {
    private GenericReferencedPQuery referencedQuery;
    private static final String DEFAULT_SUBPACKAGE = "traced";
    private static final String DEFAULT_POSTFIX = "<traced>";
    public static final String TRACE_PARAMETER = "<trace>";
    private String traceabilityId;

    public GenericTracedPQuery(GenericReferencedPQuery referencedQuery) throws QueryInitializationException {
        super(referencedQuery);
        this.referencedQuery = referencedQuery;
        this.traceabilityId = referencedQuery.getTraceabilityId();
        this.ensureInitialized();
    }

    @Override
    protected Set<PBody> doGetContainedBodies() throws QueryInitializationException {
        PBody body = super.doGetContainedBodies().iterator().next();
        PVariable var_trace = body.getOrCreateVariableByName(TRACE_PARAMETER);
        PVariable var_id = body.getOrCreateVariableByName(this.referencedQuery.getFullyQualifiedName());
        PVariable var_su = body.getOrCreateVariableByName("_");
        PVariable var_traceability = body.newConstantVariable((Object)this.traceabilityId);
        List symbolicParameters = body.getSymbolicParameters();
        Collection<String> baseParameters = this.getBaseParameters();
        symbolicParameters.add(new ExportedParameter(body, var_trace, var_trace.getName()));
        this.getParameters().add(new PParameter(var_trace.getName()));
        body.setSymbolicParameters(symbolicParameters);
        for (ExportedParameter parameter : symbolicParameters) {
            if (!baseParameters.contains(parameter.getParameterName())) continue;
            try {
                new PositivePatternCall(body, (Tuple)new FlatTuple(new Object[]{parameter.getParameterVariable(), var_id, var_su, var_trace, var_traceability}), TraceQuerySpecification.instance().getInternalQueryRepresentation());
            }
            catch (IncQueryException e) {
                Logger logger = IncQueryLoggingUtil.getLogger(GenericTracedPQuery.class);
                logger.error((Object)e.getMessage());
            }
        }
        return Collections.singleton(body);
    }

    @Override
    public String getFullyQualifiedName() {
        String fqn = this.referencedQuery.getFullyQualifiedName();
        int i = fqn.lastIndexOf(".");
        if (i == -1) {
            return String.format("%s.%s%s<%s>", DEFAULT_SUBPACKAGE, fqn, DEFAULT_POSTFIX, this.traceabilityId);
        }
        String prefix = fqn.substring(0, i);
        String name = fqn.substring(i);
        return String.format("%s.%s%s%s<%s>", prefix, DEFAULT_SUBPACKAGE, name, DEFAULT_POSTFIX, this.traceabilityId);
    }

    public void setTraceabilityId(String id) {
        this.traceabilityId = id;
    }
}

