/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.Arrays;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.codec.CompositeReadableBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportSession;

public class DeliveryImpl
implements Delivery {
    public static final int DEFAULT_MESSAGE_FORMAT = 0;
    private static final ReadableBuffer EMPTY_BUFFER = ReadableBuffer.ByteBufferReader.allocate(0);
    private DeliveryImpl _linkPrevious;
    private DeliveryImpl _linkNext;
    private DeliveryImpl _workNext;
    private DeliveryImpl _workPrev;
    boolean _work;
    private DeliveryImpl _transportWorkNext;
    private DeliveryImpl _transportWorkPrev;
    boolean _transportWork;
    private Record _attachments;
    private Object _context;
    private final byte[] _tag;
    private final LinkImpl _link;
    private DeliveryState _deliveryState;
    private boolean _settled;
    private boolean _remoteSettled;
    private DeliveryState _remoteDeliveryState;
    private DeliveryState _defaultDeliveryState = null;
    private int _messageFormat = 0;
    private int _flags = 0;
    private TransportDelivery _transportDelivery;
    private boolean _complete;
    private boolean _updated;
    private boolean _done;
    private boolean _aborted;
    private CompositeReadableBuffer _dataBuffer;
    private ReadableBuffer _dataView;

    DeliveryImpl(byte[] tag, LinkImpl link, DeliveryImpl previous) {
        this._tag = tag;
        this._link = link;
        this._link.incrementUnsettled();
        this._linkPrevious = previous;
        if (previous != null) {
            previous._linkNext = this;
        }
    }

    @Override
    public byte[] getTag() {
        return this._tag;
    }

    @Override
    public LinkImpl getLink() {
        return this._link;
    }

    @Override
    public DeliveryState getLocalState() {
        return this._deliveryState;
    }

    @Override
    public DeliveryState getRemoteState() {
        return this._remoteDeliveryState;
    }

    @Override
    public boolean remotelySettled() {
        return this._remoteSettled;
    }

    @Override
    public void setMessageFormat(int messageFormat) {
        this._messageFormat = messageFormat;
    }

    @Override
    public int getMessageFormat() {
        return this._messageFormat;
    }

    @Override
    public void disposition(DeliveryState state) {
        this._deliveryState = state;
        if (!this._remoteSettled && !this._settled) {
            this.addToTransportWorkList();
        }
    }

    @Override
    public void settle() {
        if (this._settled) {
            return;
        }
        this._settled = true;
        this._link.decrementUnsettled();
        if (!this._remoteSettled) {
            this.addToTransportWorkList();
        } else {
            this._transportDelivery.settled();
        }
        if (this._link.current() == this) {
            this._link.advance();
        }
        this._link.remove(this);
        if (this._linkPrevious != null) {
            this._linkPrevious._linkNext = this._linkNext;
        }
        if (this._linkNext != null) {
            this._linkNext._linkPrevious = this._linkPrevious;
        }
        this.updateWork();
        this._linkNext = null;
        this._linkPrevious = null;
    }

    DeliveryImpl getLinkNext() {
        return this._linkNext;
    }

    @Override
    public DeliveryImpl next() {
        return this.getLinkNext();
    }

    @Override
    public void free() {
        this.settle();
    }

    DeliveryImpl getLinkPrevious() {
        return this._linkPrevious;
    }

    @Override
    public DeliveryImpl getWorkNext() {
        if (this._workNext != null) {
            return this._workNext;
        }
        if (!this._work) {
            return this._link.getConnectionImpl().getWorkHead();
        }
        return null;
    }

    DeliveryImpl getWorkPrev() {
        return this._workPrev;
    }

    void setWorkNext(DeliveryImpl workNext) {
        this._workNext = workNext;
    }

    void setWorkPrev(DeliveryImpl workPrev) {
        this._workPrev = workPrev;
    }

    int recv(byte[] bytes, int offset, int size) {
        int consumed;
        if (this._dataBuffer != null && this._dataBuffer.hasRemaining()) {
            consumed = Math.min(size, this._dataBuffer.remaining());
            this._dataBuffer.get(bytes, offset, consumed);
            this._dataBuffer.reclaimRead();
        } else {
            consumed = 0;
        }
        return this._complete && consumed == 0 ? -1 : consumed;
    }

    int recv(WritableBuffer buffer) {
        int consumed;
        if (this._dataBuffer != null && this._dataBuffer.hasRemaining()) {
            consumed = Math.min(buffer.remaining(), this._dataBuffer.remaining());
            buffer.put(this._dataBuffer);
            this._dataBuffer.reclaimRead();
        } else {
            consumed = 0;
        }
        return this._complete && consumed == 0 ? -1 : consumed;
    }

    ReadableBuffer recv() {
        ReadableBuffer result = this._dataView;
        if (this._dataView != null) {
            this._dataBuffer = null;
            this._dataView = null;
        } else {
            result = EMPTY_BUFFER;
        }
        return result;
    }

    void updateWork() {
        this.getLink().getConnectionImpl().workUpdate(this);
    }

    DeliveryImpl clearTransportWork() {
        DeliveryImpl next = this._transportWorkNext;
        this.getLink().getConnectionImpl().removeTransportWork(this);
        return next;
    }

    void addToTransportWorkList() {
        TransportSession transportSession = this.getLink().getSession().getTransportSession();
        if (transportSession != null && transportSession.endSent()) {
            return;
        }
        this.getLink().getConnectionImpl().addTransportWork(this);
    }

    DeliveryImpl getTransportWorkNext() {
        return this._transportWorkNext;
    }

    DeliveryImpl getTransportWorkPrev() {
        return this._transportWorkPrev;
    }

    void setTransportWorkNext(DeliveryImpl transportWorkNext) {
        this._transportWorkNext = transportWorkNext;
    }

    void setTransportWorkPrev(DeliveryImpl transportWorkPrev) {
        this._transportWorkPrev = transportWorkPrev;
    }

    TransportDelivery getTransportDelivery() {
        return this._transportDelivery;
    }

    void setTransportDelivery(TransportDelivery transportDelivery) {
        this._transportDelivery = transportDelivery;
    }

    @Override
    public boolean isSettled() {
        return this._settled;
    }

    int send(byte[] bytes, int offset, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(bytes, offset, copy, 0, length);
        this.getOrCreateDataBuffer().append(copy);
        this.addToTransportWorkList();
        return length;
    }

    int send(ReadableBuffer buffer) {
        int length = buffer.remaining();
        this.getOrCreateDataBuffer().append(this.copyContents(buffer));
        this.addToTransportWorkList();
        return length;
    }

    int sendNoCopy(ReadableBuffer buffer) {
        int length = buffer.remaining();
        if (this._dataView == null || !this._dataView.hasRemaining()) {
            this._dataView = buffer;
        } else {
            this.consolidateSendBuffers(buffer);
        }
        this.addToTransportWorkList();
        return length;
    }

    private byte[] copyContents(ReadableBuffer buffer) {
        byte[] copy = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + buffer.position(), copy, 0, buffer.remaining());
            buffer.position(buffer.limit());
        } else {
            buffer.get(copy, 0, buffer.remaining());
        }
        return copy;
    }

    private void consolidateSendBuffers(ReadableBuffer buffer) {
        if (this._dataView == this._dataBuffer) {
            this.getOrCreateDataBuffer().append(this.copyContents(buffer));
        } else {
            ReadableBuffer oldView = this._dataView;
            CompositeReadableBuffer dataBuffer = this.getOrCreateDataBuffer();
            dataBuffer.append(this.copyContents(oldView));
            dataBuffer.append(this.copyContents(buffer));
            oldView.reclaimRead();
        }
        buffer.reclaimRead();
    }

    void append(Binary payload) {
        byte[] data = payload.getArray();
        if (payload.getArrayOffset() > 0 || payload.getLength() < data.length) {
            data = new byte[payload.getLength()];
            System.arraycopy(payload.getArray(), payload.getArrayOffset(), data, 0, payload.getLength());
        }
        this.getOrCreateDataBuffer().append(data);
    }

    private CompositeReadableBuffer getOrCreateDataBuffer() {
        if (this._dataBuffer == null) {
            this._dataBuffer = new CompositeReadableBuffer();
            this._dataView = this._dataBuffer;
        }
        return this._dataBuffer;
    }

    void append(byte[] data) {
        this.getOrCreateDataBuffer().append(data);
    }

    void afterSend() {
        if (this._dataView != null) {
            this._dataView.reclaimRead();
            if (!this._dataView.hasRemaining()) {
                this._dataView = this._dataBuffer;
            }
        }
    }

    ReadableBuffer getData() {
        return this._dataView == null ? EMPTY_BUFFER : this._dataView;
    }

    int getDataLength() {
        return this._dataView == null ? 0 : this._dataView.remaining();
    }

    @Override
    public int available() {
        return this._dataView == null ? 0 : this._dataView.remaining();
    }

    @Override
    public boolean isWritable() {
        return this.getLink() instanceof SenderImpl && this.getLink().current() == this && ((SenderImpl)this.getLink()).hasCredit();
    }

    @Override
    public boolean isReadable() {
        return this.getLink() instanceof ReceiverImpl && this.getLink().current() == this;
    }

    void setComplete() {
        this._complete = true;
    }

    void setAborted() {
        this._aborted = true;
    }

    @Override
    public boolean isAborted() {
        return this._aborted;
    }

    @Override
    public boolean isPartial() {
        return !this._complete;
    }

    void setRemoteDeliveryState(DeliveryState remoteDeliveryState) {
        this._remoteDeliveryState = remoteDeliveryState;
        this._updated = true;
    }

    @Override
    public boolean isUpdated() {
        return this._updated;
    }

    @Override
    public void clear() {
        this._updated = false;
        this.getLink().getConnectionImpl().workUpdate(this);
    }

    void setDone() {
        this._done = true;
    }

    boolean isDone() {
        return this._done;
    }

    void setRemoteSettled(boolean remoteSettled) {
        this._remoteSettled = remoteSettled;
        this._updated = true;
    }

    @Override
    public boolean isBuffered() {
        if (this._remoteSettled) {
            return false;
        }
        if (this.getLink() instanceof SenderImpl) {
            if (this.isDone()) {
                return false;
            }
            boolean hasRemaining = false;
            if (this._dataView != null) {
                hasRemaining = this._dataView.hasRemaining();
            }
            return this._complete || hasRemaining;
        }
        return false;
    }

    @Override
    public Object getContext() {
        return this._context;
    }

    @Override
    public void setContext(Object context) {
        this._context = context;
    }

    @Override
    public Record attachments() {
        if (this._attachments == null) {
            this._attachments = new RecordImpl();
        }
        return this._attachments;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeliveryImpl [_tag=").append(Arrays.toString(this._tag)).append(", _link=").append(this._link).append(", _deliveryState=").append(this._deliveryState).append(", _settled=").append(this._settled).append(", _remoteSettled=").append(this._remoteSettled).append(", _remoteDeliveryState=").append(this._remoteDeliveryState).append(", _flags=").append(this._flags).append(", _defaultDeliveryState=").append(this._defaultDeliveryState).append(", _transportDelivery=").append(this._transportDelivery).append(", _data Size=").append(this.getDataLength()).append(", _complete=").append(this._complete).append(", _updated=").append(this._updated).append(", _done=").append(this._done).append("]");
        return builder.toString();
    }

    @Override
    public int pending() {
        return this._dataView == null ? 0 : this._dataView.remaining();
    }

    @Override
    public void setDefaultDeliveryState(DeliveryState state) {
        this._defaultDeliveryState = state;
    }

    @Override
    public DeliveryState getDefaultDeliveryState() {
        return this._defaultDeliveryState;
    }
}

