/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2.ContainerResourceMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2.ContainerResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricTarget;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricTargetBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricTargetFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ContainerResourceMetricSourceFluentImpl<A extends ContainerResourceMetricSourceFluent<A>>
extends BaseFluent<A>
implements ContainerResourceMetricSourceFluent<A> {
    private String container;
    private String name;
    private MetricTargetBuilder target;
    private Map<String, Object> additionalProperties;

    public ContainerResourceMetricSourceFluentImpl() {
    }

    public ContainerResourceMetricSourceFluentImpl(ContainerResourceMetricSource instance) {
        if (instance != null) {
            this.withContainer(instance.getContainer());
            this.withName(instance.getName());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public MetricTarget getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(MetricTarget target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> withNewTargetLike(MetricTarget item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new MetricTargetBuilder().build());
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> editOrNewTargetLike(MetricTarget item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerResourceMetricSourceFluentImpl that = (ContainerResourceMetricSourceFluentImpl)o;
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.container, this.name, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetNestedImpl<N>
    extends MetricTargetFluentImpl<ContainerResourceMetricSourceFluent.TargetNested<N>>
    implements ContainerResourceMetricSourceFluent.TargetNested<N>,
    Nested<N> {
        MetricTargetBuilder builder;

        TargetNestedImpl(MetricTarget item) {
            this.builder = new MetricTargetBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new MetricTargetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerResourceMetricSourceFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }
}

