/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.uml;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.integration.tests.uml.AbstractUMLIndexingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UMLIndexingTest
extends AbstractUMLIndexingTest {
    private static final String SIMPLE_PROFILE_NSURI_PREFIX = "http://github.com/mondo-project/mondo-hawk/simpleProfile";
    @Rule
    public TemporaryFolder modelFolder = new TemporaryFolder();

    public UMLIndexingTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf);
    }

    @Test
    public void zoo() throws Throwable {
        this.requestFolderIndex(new File(new File(this.baseDir, "resources/models/uml"), "zoo"));
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.eol("return Model.types.select(t|t.name='Profile').size;"));
            Assert.assertEquals((Object)4, (Object)this.eol("return Class.all.size;", Collections.singletonMap("FILE", "*model.uml")));
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                EOLQueryEngine.GraphNodeWrapper attr = (EOLQueryEngine.GraphNodeWrapper)this.eol("return Class.all.selectOne(c|c.name='Animal').ownedAttribute.selectOne(a|a.name='age');");
                IGraphNode node = attr.getNode();
                Iterable itOutgoing = node.getOutgoingWithType("type");
                int size = 0;
                for (IGraphEdge e : itOutgoing) {
                    ++size;
                }
                Assert.assertEquals((long)1L, (long)size);
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    @Test
    public void stereotypeAsModel() throws Throwable {
        this.requestFolderIndex(new File(new File(this.baseDir, "resources/models/uml"), "simpleProfile"));
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.eol("return Stereotype.all.select(s|s.name='special').size;"));
            return null;
        });
    }

    @Test
    public void indexLibraries() throws Throwable {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            Assert.assertEquals((Object)4, (Object)this.eol("return Package.all.size;"));
            Assert.assertEquals((Object)4, (Object)this.eol("return ModelLibrary.all.size;"));
            Assert.assertEquals((Object)4, (Object)this.eol("return ModelLibrary.all.base_Package.flatten.size;"));
            Assert.assertEquals((Object)5, (Object)this.eol("return EDataType.all.size;", Collections.singletonMap("DEFAULTNAMESPACES", "http://www.eclipse.org/uml2/schemas/Ecore/5")));
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void customProfileV4() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(new File(this.baseDir, "resources/models/uml"), "simpleProfile/model.profile.uml")});
        this.requestFolderIndex(new File(new File(this.baseDir, "resources/models/uml"), "simpleProfileApplication"));
        this.scheduleAndWait(() -> {
            Map<String, Object> ctx = Collections.singletonMap("DEFAULTNAMESPACES", "http://github.com/mondo-project/mondo-hawk/simpleProfile/0.0.4");
            Assert.assertEquals((Object)1, (Object)this.eol("return special.all.size;", ctx));
            Assert.assertEquals((Object)9001, (Object)this.eol("return special.all.first.amount;", ctx));
            Assert.assertEquals((Object)"Example", (Object)this.eol("return special.all.first.base_Class.name;", ctx));
            Assert.assertEquals((Object)1, (Object)this.eol("return RootElementApplication.all.size;", ctx));
            Assert.assertEquals((Object)"Example", (Object)this.eol("return RootElementApplication.all.packagedElement.flatten.first.name;", ctx));
            return null;
        });
    }

    @Test
    public void customProfileV5() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(new File(this.baseDir, "resources/models/uml"), "simpleProfile/model.profile.uml")});
        this.requestFolderIndex(new File(new File(this.baseDir, "resources/models/uml"), "simpleProfileApplicationNewVersion"));
        this.scheduleAndWait(() -> {
            Map<String, Object> ctx = Collections.singletonMap("DEFAULTNAMESPACES", "http://github.com/mondo-project/mondo-hawk/simpleProfile/0.0.5");
            Assert.assertEquals((Object)1, (Object)this.eol("return special.all.size;", ctx));
            Assert.assertEquals((Object)9002, (Object)this.eol("return special.all.first.amount;", ctx));
            Assert.assertEquals((Object)"example", (Object)this.eol("return special.all.first.name;", ctx));
            Assert.assertEquals((Object)"Example", (Object)this.eol("return special.all.first.base_Class.name;", ctx));
            return null;
        });
    }

    @Test
    public void upgradeModelProfileVersion() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(new File(this.baseDir, "resources/models/uml"), "simpleProfile/model.profile.uml")});
        URI destURI = URI.createFileURI((String)new File(this.modelFolder.getRoot(), "model.uml").getCanonicalFile().toString());
        File oldFile = new File(new File(this.baseDir, "resources/models/uml"), "simpleProfileApplication/model.uml").getCanonicalFile();
        this.copyResource(destURI, oldFile);
        this.requestFolderIndex(this.modelFolder.getRoot());
        Map<String, String> ctxOldVersion = Collections.singletonMap("DEFAULTNAMESPACES", "http://github.com/mondo-project/mondo-hawk/simpleProfile/0.0.4");
        Map<String, String> ctxNewVersion = Collections.singletonMap("DEFAULTNAMESPACES", "http://github.com/mondo-project/mondo-hawk/simpleProfile/0.0.5");
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.eol("return special.all.size;", ctxOldVersion));
            Assert.assertEquals((Object)0, (Object)this.eol("return special.all.size;", ctxNewVersion));
            return null;
        });
        File newFile = new File(new File(this.baseDir, "resources/models/uml"), "simpleProfileApplicationNewVersion/model.uml").getCanonicalFile();
        this.copyResource(destURI, newFile);
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)0, (Object)this.eol("return special.all.size;", ctxOldVersion));
            Assert.assertEquals((Object)1, (Object)this.eol("return special.all.size;", ctxNewVersion));
            return null;
        });
    }

    @Test
    public void modelProfileInsideRepository() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(new File(this.baseDir, "resources/models/uml"), "simpleProfile/model.profile.uml")});
        FileUtils.copyDirectory((File)new File(this.baseDir, "resources/models/uml"), (File)this.modelFolder.getRoot());
        FileUtils.deleteDirectory((File)new File(this.modelFolder.getRoot(), "simpleProfileApplicationNewVersion"));
        this.requestFolderIndex(this.modelFolder.getRoot());
        Map<String, String> ctxOldVersion = Collections.singletonMap("DEFAULTNAMESPACES", "http://github.com/mondo-project/mondo-hawk/simpleProfile/0.0.4");
        Map<String, String> ctxNewVersion = Collections.singletonMap("DEFAULTNAMESPACES", "http://github.com/mondo-project/mondo-hawk/simpleProfile/0.0.5");
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.eol("return special.all.size;", ctxOldVersion));
            Assert.assertEquals((Object)0, (Object)this.eol("return special.all.size;", ctxNewVersion));
            return null;
        });
        FileUtils.copyFile((File)new File(new File(this.baseDir, "resources/models/uml"), "simpleProfileApplicationNewVersion/model.uml"), (File)new File(this.modelFolder.getRoot(), "simpleProfileApplication/model.uml"));
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)0, (Object)this.eol("return special.all.size;", ctxOldVersion));
            Assert.assertEquals((Object)1, (Object)this.eol("return special.all.size;", ctxNewVersion));
            return null;
        });
    }

    @Test
    public void localfolderCrosslinks() throws Throwable {
        this.requestFolderIndex(new File(new File(this.baseDir, "resources/models/uml"), "crossfile-refs"));
        this.scheduleAndWait(() -> {
            Map<String, Object> ctx = Collections.singletonMap("FILE", "*model.uml");
            Assert.assertEquals((Object)3, (Object)this.eol("return Class.all.size;", ctx));
            Assert.assertEquals(new HashSet<String>(Arrays.asList("Class1", "Class3")), (Object)this.eol("return Class.all.selectOne(c|c.name='Class2').generalization.general.name.flatten.asSet;", ctx));
            return false;
        });
    }
}

