/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.hawk.service.api.EffectiveMetamodelRuleset;

public class EffectiveMetamodelRulesetSerializer {
    private static final char SEPARATOR = '.';
    static final String INCLUDES_SUFFIX = ".includes";
    static final String EXCLUDES_SUFFIX = ".excludes";
    private final String propertyPrefix;

    public EffectiveMetamodelRulesetSerializer(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public EffectiveMetamodelRuleset load(Properties props) {
        ImmutableSet slots;
        String typeName;
        TreeMap<Integer, String> incMetamodels = new TreeMap<Integer, String>();
        TreeBasedTable incTypeTable = TreeBasedTable.create();
        TreeBasedTable incSlotTable = TreeBasedTable.create();
        TreeMap<Integer, String> excMetamodels = new TreeMap<Integer, String>();
        TreeBasedTable excTypeTable = TreeBasedTable.create();
        TreeBasedTable excSlotTable = TreeBasedTable.create();
        for (String propName : props.stringPropertyNames()) {
            String unprefixed;
            boolean isIncludes;
            if (!propName.startsWith(this.propertyPrefix)) continue;
            String raw = propName.substring(this.propertyPrefix.length());
            if (raw.startsWith(INCLUDES_SUFFIX)) {
                isIncludes = true;
                unprefixed = raw.substring(INCLUDES_SUFFIX.length());
            } else {
                if (!raw.startsWith(EXCLUDES_SUFFIX)) continue;
                isIncludes = false;
                unprefixed = raw.substring(EXCLUDES_SUFFIX.length());
            }
            String[] parts = unprefixed.split("[.]");
            String propValue = props.getProperty(propName).trim();
            switch (parts.length) {
                case 1: {
                    int iMetamodel = Integer.valueOf(parts[0]);
                    String mmURI = propValue;
                    if (isIncludes) {
                        incMetamodels.put(iMetamodel, mmURI);
                        break;
                    }
                    excMetamodels.put(iMetamodel, mmURI);
                    break;
                }
                case 2: {
                    int iMetamodel = Integer.valueOf(parts[0]);
                    int iType = Integer.valueOf(parts[1]);
                    String type = propValue;
                    if (isIncludes) {
                        incTypeTable.put((Object)iMetamodel, (Object)iType, (Object)type);
                        break;
                    }
                    excTypeTable.put((Object)iMetamodel, (Object)iType, (Object)type);
                    break;
                }
                case 3: {
                    int iMetamodel = Integer.valueOf(parts[0]);
                    int iType = Integer.valueOf(parts[1]);
                    ImmutableSet slots2 = propValue.length() > 0 ? ImmutableSet.copyOf((Object[])propValue.split("[.]")) : ImmutableSet.of();
                    if (isIncludes) {
                        incSlotTable.put((Object)iMetamodel, (Object)iType, (Object)slots2);
                        break;
                    }
                    excSlotTable.put((Object)iMetamodel, (Object)iType, (Object)slots2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Property %s should only have 1-3 parts, but has %d", propName, parts.length));
                }
            }
        }
        EffectiveMetamodelRuleset ruleset = new EffectiveMetamodelRuleset();
        for (Table.Cell mmEntry : incSlotTable.cellSet()) {
            String mmURI = (String)incMetamodels.get(mmEntry.getRowKey());
            typeName = (String)incTypeTable.get(mmEntry.getRowKey(), mmEntry.getColumnKey());
            slots = (ImmutableSet)mmEntry.getValue();
            if ("*".equals(typeName)) {
                ruleset.include(mmURI);
                continue;
            }
            if (slots.contains((Object)"*")) {
                ruleset.include(mmURI, typeName);
                continue;
            }
            ruleset.include(mmURI, typeName, slots);
        }
        for (Table.Cell mmEntry : excSlotTable.cellSet()) {
            String mmURI = (String)excMetamodels.get(mmEntry.getRowKey());
            typeName = (String)excTypeTable.get(mmEntry.getRowKey(), mmEntry.getColumnKey());
            slots = (ImmutableSet)mmEntry.getValue();
            if ("*".equals(typeName)) {
                ruleset.exclude(mmURI);
                continue;
            }
            if (slots.contains((Object)"*")) {
                ruleset.exclude(mmURI, typeName);
                continue;
            }
            ruleset.exclude(mmURI, typeName, slots);
        }
        return ruleset;
    }

    public void save(EffectiveMetamodelRuleset rules, Properties props) {
        if (rules.isEverythingIncluded()) {
            return;
        }
        this.save((Table<String, String, ImmutableSet<String>>)rules.getInclusionRules(), INCLUDES_SUFFIX, props);
        this.save((Table<String, String, ImmutableSet<String>>)rules.getExclusionRules(), EXCLUDES_SUFFIX, props);
    }

    private void save(Table<String, String, ImmutableSet<String>> table, String suffix, Properties props) {
        int iMetamodel = 0;
        for (Map.Entry mmEntry : table.rowMap().entrySet()) {
            String mmURI = (String)mmEntry.getKey();
            props.put(String.valueOf(this.propertyPrefix) + suffix + iMetamodel, mmURI);
            int iType = 0;
            for (Map.Entry typeEntry : ((Map)mmEntry.getValue()).entrySet()) {
                String type = (String)typeEntry.getKey();
                props.put(String.valueOf(this.propertyPrefix) + suffix + iMetamodel + '.' + iType, type);
                Set slots = (Set)typeEntry.getValue();
                StringBuffer sbuf = new StringBuffer();
                boolean first = true;
                for (String slot : slots) {
                    if (first) {
                        first = false;
                    } else {
                        sbuf.append('.');
                    }
                    sbuf.append(slot);
                }
                props.put(String.valueOf(this.propertyPrefix) + suffix + iMetamodel + '.' + iType + '.' + "slots", sbuf.toString());
                ++iType;
            }
            ++iMetamodel;
        }
    }
}

