/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.remote.thrift;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.auth.Credentials;
import org.apache.thrift.transport.TTransportException;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawk;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.dt.http.LazyCredentials;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.remote.thrift.ThriftRemoteHawkFactory;
import org.eclipse.hawk.service.remote.thrift.ThriftRemoteModelIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftRemoteHawk
implements IHawk {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftRemoteHawk.class);
    private ThriftRemoteModelIndexer indexer;
    private File folder;

    public ThriftRemoteHawk(String name, String location, ThriftRemoteHawkFactory factory, File parentFolder, ICredentialsStore credStore, IConsole console, APIUtils.ThriftProtocol thriftProtocol, List<String> enabledPlugins) throws TTransportException, IOException, URISyntaxException {
        this.folder = parentFolder;
        new URI(location);
        this.indexer = new ThriftRemoteModelIndexer(name, location, factory, parentFolder, () -> {
            try {
                return (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)location, (APIUtils.ThriftProtocol)thriftProtocol, (Credentials)new LazyCredentials(location));
            }
            catch (URISyntaxException | TTransportException e) {
                LOGGER.error(e.getMessage(), e);
                return null;
            }
        }, credStore, console, enabledPlugins);
    }

    public IModelIndexer getModelIndexer() {
        return this.indexer;
    }

    public String getDatabaseType() {
        return this.indexer.getDBType();
    }

    public void setDatabaseType(String dbtype) {
        this.indexer.setDBType(dbtype);
    }

    public boolean exists() {
        return this.folder != null && this.folder.exists();
    }
}

