/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.util.function.Function;

public final class Loader
implements Function<String, Class<?>> {
    private final ClassLoader loader;

    Loader(ClassLoader loader) {
        this.loader = loader;
    }

    public static Loader forClassLoader(ClassLoader loader) {
        return new Loader(loader);
    }

    public static Loader forCurrentThread() {
        return new Loader(Thread.currentThread().getContextClassLoader());
    }

    public static Loader forClass(Class<?> klass) {
        return new Loader(klass.getClassLoader());
    }

    static Loader forObject(Object obj) {
        return Loader.forClass(obj.getClass());
    }

    public Class<?> load(String name) {
        try {
            return this.loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Class<?> apply(String name) {
        return this.load(name);
    }
}

