/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import gololang.IO;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.AugmentationDocumentation;
import org.eclipse.golo.doc.FunctionDocumentation;
import org.eclipse.golo.doc.MemberDocumentation;
import org.eclipse.golo.doc.ModuleDocumentation;
import org.eclipse.golo.doc.NamedAugmentationDocumentation;
import org.eclipse.golo.doc.StructDocumentation;
import org.eclipse.golo.doc.UnionDocumentation;

public class CtagsProcessor
extends AbstractProcessor {
    private final LinkedList<String> ctags = new LinkedList();
    private String file = "file";

    private void ctagsLine(String name, String address, String field) {
        this.ctags.add(String.format("%s\t%s\t%s;\"\t%s\tlanguage:golo%n", name, this.file, address, field));
    }

    private void ctagsModule(ModuleDocumentation module) {
        this.ctagsLine(module.moduleName(), "/^module[:blank:]+" + module.moduleName().replace(".", "\\.") + "$/", "p\tline:" + module.moduleDefLine());
    }

    private void ctagsFunction(FunctionDocumentation funct) {
        this.ctagsFunction(funct, "", false);
    }

    private void ctagsFunction(FunctionDocumentation funct, String parent, boolean named) {
        this.ctagsFunction(funct, parent, named, "function", "f");
    }

    private void ctagsFunction(FunctionDocumentation funct, String parent, boolean named, String keyword, String tag) {
        String address = String.format("/%s[:blank:]+%s[:blank:]+=/", keyword, funct.name());
        StringBuilder signature = new StringBuilder("\tsignature:(");
        if (funct.arity() > 0) {
            signature.append(funct.argument(0));
            for (int i = 1; i < funct.arity(); ++i) {
                signature.append(", ").append(funct.argument(i));
            }
            if (funct.varargs()) {
                signature.append("...");
            }
        }
        signature.append(")");
        StringBuilder fields = new StringBuilder(tag);
        fields.append("\tline:").append(funct.line());
        if (funct.local()) {
            fields.append("\taccess:private\tfile:");
        } else {
            fields.append("\taccess:public");
        }
        fields.append((CharSequence)signature);
        if (!parent.isEmpty()) {
            if (named) {
                fields.append("\taugmentation:").append(parent);
            } else {
                fields.append("\taugment:").append(parent);
            }
        }
        this.ctagsLine(funct.name(), address, fields.toString());
    }

    private void ctagsAugment(String name, int line) {
        this.ctagsLine(name, String.format("/^augment[:blank:]+%s/", name.replace(".", "\\.")), String.format("a\tline:%s", line));
    }

    private void ctagsAugmentation(String name, int line) {
        this.ctagsLine(name, String.format("/^augmentation[:blank:]+%s[:blank:]+=[:blank:]+{/", name), String.format("na\tline:%s", line));
    }

    private void ctagsStruct(String name, int line) {
        this.ctagsLine(name, String.format("/^struct[:blank:]+%s[:blank:]+=/", name), String.format("s\tline:%s", line));
    }

    private void ctagsUnion(UnionDocumentation unionDoc) {
        this.ctagsLine(unionDoc.name(), String.format("/^union[:blank:]+%s[:blank:]+=[:blank:]+{/", unionDoc.name()), String.format("g\tline:%s", unionDoc.line()));
        for (UnionDocumentation.UnionValueDocumentation valueDoc : unionDoc.values()) {
            this.ctagsUnionValue(unionDoc.name(), valueDoc);
        }
    }

    private void ctagsUnionValue(String unionName, UnionDocumentation.UnionValueDocumentation valueDoc) {
        this.ctagsLine(valueDoc.name(), String.format("/[:blank:]+%s[:blank:]+%s", valueDoc.name(), valueDoc.hasMembers() ? "[:blank:]*=[:blank:]+{" : ""), String.format("e\tline:%s\tunion:%s", valueDoc.line(), unionName));
        for (MemberDocumentation member : valueDoc.members()) {
            this.ctagsLine(member.name(), String.format("/[:blank:]+%s[:blank:]+=/", valueDoc.name()), String.format("m\tline:%s\taccess:public\tvalue:%s", member.line(), valueDoc.name()));
        }
    }

    private void ctagsImport(String name, int line) {
        this.ctagsLine(name, String.format("/^import[:blank:]+%s/", name.replace(".", "\\.")), String.format("i\tline:%s", line));
    }

    private void ctagsModState(String name, int line) {
        this.ctagsLine(name, String.format("(let|var)[:blank:]+%s[:blank:]+=/", name), String.format("v\taccess:private\tfile:\tline:%s", line));
    }

    private void ctagsStructMember(String struct, String member, int line) {
        this.ctagsLine(member, String.format("/struct[:blank:]+%s[:blank:]+=/", struct), String.format("m\tline:%s\taccess:%s\tstruct:%s", line, member.charAt(0) == '_' ? "private" : "public", struct));
    }

    private String ctagsAsString() {
        Collections.sort(this.ctags);
        StringBuilder buffer = new StringBuilder();
        for (String line : this.ctags) {
            buffer.append(line);
        }
        return buffer.toString();
    }

    @Override
    public String render(ModuleDocumentation documentation) throws Throwable {
        this.ctagsModule(documentation);
        for (Map.Entry<String, Integer> entry : documentation.imports().entrySet()) {
            this.ctagsImport(entry.getKey(), entry.getValue());
        }
        for (StructDocumentation structDocumentation : documentation.structs()) {
            this.ctagsStruct(structDocumentation.name(), structDocumentation.line());
            for (MemberDocumentation member : structDocumentation.members()) {
                this.ctagsStructMember(structDocumentation.name(), member.name(), member.line());
            }
        }
        for (UnionDocumentation unionDocumentation : documentation.unions()) {
            this.ctagsUnion(unionDocumentation);
        }
        for (NamedAugmentationDocumentation namedAugmentationDocumentation : documentation.namedAugmentations()) {
            this.ctagsAugmentation(namedAugmentationDocumentation.name(), namedAugmentationDocumentation.line());
            for (FunctionDocumentation funct : namedAugmentationDocumentation.functions()) {
                this.ctagsFunction(funct, namedAugmentationDocumentation.name(), true);
            }
        }
        for (AugmentationDocumentation augmentationDocumentation : documentation.augmentations()) {
            this.ctagsAugment(augmentationDocumentation.target(), augmentationDocumentation.line());
            for (FunctionDocumentation funct : augmentationDocumentation.functions()) {
                this.ctagsFunction(funct, augmentationDocumentation.target(), false);
            }
        }
        for (Map.Entry entry : documentation.moduleStates().entrySet()) {
            this.ctagsModState((String)entry.getKey(), (Integer)entry.getValue());
        }
        for (FunctionDocumentation functionDocumentation : documentation.functions(true)) {
            this.ctagsFunction(functionDocumentation);
        }
        return this.ctagsAsString();
    }

    @Override
    public void process(Collection<ModuleDocumentation> modules, Path targetFolder) throws Throwable {
        Path targetFile = null;
        targetFile = "-".equals(targetFolder.toString()) ? targetFolder : targetFolder.resolve("tags");
        this.ctags.clear();
        for (ModuleDocumentation doc : modules) {
            this.file = doc.sourceFile();
            this.render(doc);
        }
        IO.textToFile(this.ctagsAsString(), targetFile);
    }
}

