/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import gololang.FunctionReference;
import gololang.IO;
import gololang.Messages;
import gololang.TemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.golo.cli.command.Metadata;
import org.eclipse.golo.cli.command.Profile;
import org.eclipse.golo.cli.command.VCS;

class ProjectInitializer {
    private boolean force = false;
    private Path rootPath;
    private Path projectDir;
    private String projectName;
    private String runCommand = "";
    private final List<Path> directories = new LinkedList<Path>();
    private String manager;
    private String projectFileName;
    private Path sourcesDir;
    private VCS vcs;
    private final List<String> patternsToIgnore = new LinkedList<String>();
    private Profile profile;
    private final List<ProjectFile> files = new LinkedList<ProjectFile>();
    private final String version = "0.1.0-SNAPSHOT";

    ProjectInitializer() {
    }

    public ProjectInitializer runCommand(String cmd) {
        this.runCommand = cmd;
        return this;
    }

    public ProjectInitializer withFile(Path target, String templateName) {
        try {
            this.files.add(new ProjectFile(target, this.template(templateName)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private List<Path> projectDirectories() {
        return this.directories.stream().map(p -> this.projectDir.resolve((Path)p)).collect(Collectors.toList());
    }

    public ProjectInitializer directories(Path ... dir) {
        for (Path p : dir) {
            this.directories.add(p);
        }
        return this;
    }

    public ProjectInitializer manager(String name) {
        this.manager = name;
        return this;
    }

    public ProjectInitializer projectFileName(String name) {
        this.projectFileName = name;
        return this;
    }

    public ProjectInitializer sourcesDir(Path dir) {
        this.sourcesDir = dir;
        return this;
    }

    private Path sourcesDir() {
        if (this.sourcesDir == null) {
            return this.projectDir;
        }
        return this.projectDir.resolve(this.sourcesDir);
    }

    private String moduleName() {
        if (this.projectName.contains(".")) {
            return this.projectName;
        }
        StringBuilder camelCase = new StringBuilder();
        for (String word : this.projectName.split("\\W+")) {
            camelCase.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase());
        }
        return camelCase.toString();
    }

    public ProjectInitializer ignore(String ... patterns) {
        for (String p : patterns) {
            this.patternsToIgnore.add(p);
        }
        return this;
    }

    public void setRootPath(String root) {
        this.rootPath = Paths.get(root, new String[0]);
    }

    public void setVCS(VCS vcs) {
        this.vcs = vcs;
        if (vcs != null) {
            vcs.ignore(this.patternsToIgnore);
        }
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public void init(String projectName) throws Throwable {
        this.projectName = projectName;
        this.projectDir = this.mkdirs(this.rootPath.resolve(Paths.get(projectName, new String[0])));
        this.writeProjectFile();
        if (!Files.exists(this.sourcesDir(), new LinkOption[0])) {
            this.mkdirs(this.sourcesDir());
        }
        for (Path subdir : this.projectDirectories()) {
            this.mkdirs(subdir);
        }
        this.createGoloFiles();
        this.initVCS();
        for (ProjectFile f : this.files) {
            f.create(this.projectDir, this.projectName, this.moduleName(), this.version, this.profile);
        }
        for (Path dir : this.profile.directories()) {
            this.mkdirs(this.projectDir.resolve(dir));
        }
        Messages.info(Messages.message("project_created", projectName));
        if (!this.runCommand.isEmpty() && this.profile.isRunnable()) {
            Messages.info(Messages.message("project_run", this.runCommand));
        }
    }

    private void initVCS() {
        if (this.vcs != null) {
            this.vcs.directory(this.projectDir);
            try {
                this.vcs.createIgnoreFile();
            }
            catch (Exception e) {
                Messages.warning(Messages.message("ignore_file_error", this.vcs.ignoreFile()));
                Messages.warning(e);
            }
            try {
                this.vcs.init();
            }
            catch (IOException | InterruptedException | VCS.InitException e) {
                Messages.warning(Messages.message("vcs_init_error", this.vcs));
                Messages.warning(e);
            }
        }
    }

    private Path sourceFile() {
        if (this.projectName.contains(".")) {
            String[] parts = this.projectName.split("\\.");
            String first = parts[0];
            String[] rest = Arrays.copyOfRange(parts, 1, parts.length);
            int n = rest.length - 1;
            rest[n] = rest[n] + ".golo";
            return this.sourcesDir().resolve(Paths.get(first, rest));
        }
        return this.sourcesDir().resolve(this.profile.defaultFileName());
    }

    private void createGoloFiles() throws Throwable {
        this.writeFile(this.sourceFile(), this.template(this.profile.defaultFileName()).invoke(Metadata.GUIDE_BASE, this.moduleName(), this.projectName));
        if (this.profile.isRunnable()) {
            this.sourceFile().toFile().setExecutable(true);
        }
    }

    private void writeProjectFile() throws Throwable {
        if (this.manager == null || this.projectFileName == null) {
            return;
        }
        this.writeFile(this.resolve(this.projectFileName, new String[0]), this.template(this.projectFileName).invoke(this.moduleName(), this.version, this.profile.isRunnable()));
    }

    private FunctionReference template(String name) throws IOException {
        InputStream in = ProjectInitializer.class.getResourceAsStream("/org/eclipse/golo/cli/command/" + name);
        if (in == null) {
            throw new IllegalArgumentException("There is no template " + name);
        }
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            int nread;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[1024];
            while ((nread = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, nread);
            }
            FunctionReference functionReference = new TemplateEngine().compile(builder.toString());
            return functionReference;
        }
    }

    private Path resolve(String first, String ... more) {
        return this.projectDir.resolve(Paths.get(first, more));
    }

    private Path mkdirs(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0]) && !this.force) {
            throw new IOException(Messages.message("directory_exists", directory));
        }
        try {
            return Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new IOException(Messages.message("directory_exists", directory), e);
        }
        catch (Exception e) {
            throw new IOException(Messages.message("directory_not_created", directory), e);
        }
    }

    private void writeFile(Path file, Object content) throws Throwable {
        IO.textToFile(content, file, StandardCharsets.UTF_8);
    }

    static class ProjectFile {
        private final Path target;
        private final FunctionReference template;

        ProjectFile(Path target, FunctionReference template) {
            this.target = target;
            this.template = template;
        }

        public void create(Path root, Object ... args) throws Throwable {
            IO.textToFile(this.template.invoke(args), root.resolve(this.target), StandardCharsets.UTF_8);
        }
    }
}

