/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.OperatorType;
import java.util.Collections;
import java.util.List;

public final class UnaryOperation
extends ExpressionStatement<UnaryOperation> {
    private final OperatorType type;
    private ExpressionStatement<?> expressionStatement;

    UnaryOperation(OperatorType type, ExpressionStatement<?> expressionStatement) {
        this.type = type;
        this.setExpressionStatement(expressionStatement);
    }

    public static UnaryOperation create(Object type, Object expression) {
        return new UnaryOperation(OperatorType.of(type), ExpressionStatement.of(expression));
    }

    @Override
    protected UnaryOperation self() {
        return this;
    }

    public ExpressionStatement<?> expression() {
        return this.expressionStatement;
    }

    private void setExpressionStatement(ExpressionStatement<?> statement) {
        this.expressionStatement = this.makeParentOf(statement);
    }

    public OperatorType getType() {
        return this.type;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnaryOperation(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        return Collections.singletonList(this.expressionStatement);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.expressionStatement.equals(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement(ExpressionStatement.of(newElement));
    }
}

