/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.LocalReference;
import gololang.ir.ReferenceTable;

public final class ReferenceLookup
extends ExpressionStatement<ReferenceLookup> {
    private final String name;

    private ReferenceLookup(String name) {
        this.name = name;
    }

    public static ReferenceLookup of(Object name) {
        if (name instanceof ReferenceLookup) {
            return (ReferenceLookup)name;
        }
        if (name instanceof LocalReference) {
            return new ReferenceLookup(((LocalReference)name).getName());
        }
        return new ReferenceLookup(name.toString());
    }

    @Override
    protected ReferenceLookup self() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public LocalReference resolveIn(ReferenceTable referenceTable) {
        return referenceTable.get(this.name);
    }

    public LocalReference varRef() {
        return LocalReference.of(this.name).variable();
    }

    public LocalReference letRef() {
        return LocalReference.of(this.name);
    }

    public String toString() {
        return String.format("Ref{name=%s}", this.getName());
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitReferenceLookup(this);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        throw this.cantReplace();
    }
}

