/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.AssignmentStatement;
import gololang.ir.Augmentation;
import gololang.ir.BinaryOperation;
import gololang.ir.Block;
import gololang.ir.CaseStatement;
import gololang.ir.ClosureReference;
import gololang.ir.CollectionComprehension;
import gololang.ir.CollectionLiteral;
import gololang.ir.ConditionalBranching;
import gololang.ir.ConstantStatement;
import gololang.ir.Decorator;
import gololang.ir.DestructuringAssignment;
import gololang.ir.ExpressionStatement;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloAssignment;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloModule;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.LoopBreakFlowStatement;
import gololang.ir.LoopStatement;
import gololang.ir.MatchExpression;
import gololang.ir.Member;
import gololang.ir.MethodInvocation;
import gololang.ir.ModuleImport;
import gololang.ir.NamedArgument;
import gololang.ir.NamedAugmentation;
import gololang.ir.Noop;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReturnStatement;
import gololang.ir.Struct;
import gololang.ir.ThrowStatement;
import gololang.ir.ToplevelElements;
import gololang.ir.TryCatchFinally;
import gololang.ir.UnaryOperation;
import gololang.ir.Union;
import gololang.ir.UnionValue;
import gololang.ir.WhenClause;
import java.io.PrintStream;

public class IrTreeDumper
implements GoloIrVisitor {
    private final PrintStream out;
    private int spacing = 0;
    private GoloModule currentModule;

    public IrTreeDumper() {
        this(System.out);
    }

    public IrTreeDumper(PrintStream out) {
        this.out = out;
    }

    private void space() {
        this.out.print("# ");
        for (int i = 0; i < this.spacing; ++i) {
            this.out.print(" ");
        }
    }

    private void incr() {
        this.spacing += 2;
    }

    private void decr() {
        this.spacing -= 2;
    }

    @Override
    public void visitModule(GoloModule module) {
        if (this.currentModule == module) {
            this.incr();
            this.space();
            this.out.println("current module");
            this.decr();
            return;
        }
        this.currentModule = module;
        this.space();
        this.out.print(module.getPackageAndClass());
        this.out.print(" [Local References: ");
        this.out.print(System.identityHashCode(module.getReferenceTable()));
        this.out.println("]");
        module.walk(this);
    }

    @Override
    public void visitModuleImport(ModuleImport moduleImport) {
        this.incr();
        this.space();
        this.out.append(" - ").println(moduleImport);
        moduleImport.walk(this);
        this.decr();
    }

    @Override
    public void visitNamedAugmentation(NamedAugmentation namedAugmentation) {
        this.incr();
        this.space();
        this.out.append("Named Augmentation ").println(namedAugmentation.getName());
        namedAugmentation.walk(this);
        this.decr();
    }

    @Override
    public void visitAugmentation(Augmentation augmentation) {
        this.incr();
        this.space();
        this.out.append("Augmentation on ").println(augmentation.getTarget());
        if (augmentation.hasNames()) {
            this.incr();
            for (String name : augmentation.getNames()) {
                this.space();
                this.out.append("Named Augmentation ").println(name);
            }
            this.decr();
        }
        augmentation.walk(this);
        this.decr();
    }

    @Override
    public void visitStruct(Struct struct) {
        this.incr();
        this.space();
        this.out.append("Struct ").println(struct.getPackageAndClass().className());
        this.space();
        this.out.append(" - target class = ").println(struct.getPackageAndClass());
        this.incr();
        this.space();
        this.out.println("Members: ");
        struct.walk(this);
        this.decr();
        this.decr();
    }

    @Override
    public void visitUnion(Union union) {
        this.incr();
        this.space();
        this.out.append("Union ").println(union.getPackageAndClass().className());
        this.space();
        this.out.append(" - target class = ").println(union.getPackageAndClass());
        union.walk(this);
        this.decr();
    }

    @Override
    public void visitUnionValue(UnionValue value) {
        this.incr();
        this.space();
        this.out.append("Value ").println(value.getPackageAndClass().className());
        this.space();
        this.out.append(" - target class = ").println(value.getPackageAndClass());
        if (value.hasMembers()) {
            this.incr();
            this.space();
            this.out.println("Members: ");
            value.walk(this);
            this.decr();
        }
        this.decr();
    }

    @Override
    public void visitFunction(GoloFunction function) {
        this.incr();
        this.space();
        if (function.isLocal()) {
            this.out.print("Local function ");
        } else {
            this.out.print("Function ");
        }
        this.out.append(function.getName()).append(" = ");
        this.visitFunctionDefinition(function);
        this.decr();
    }

    private void visitFunctionDefinition(GoloFunction function) {
        this.out.print("|");
        boolean first = true;
        for (String param : function.getParameterNames()) {
            if (first) {
                first = false;
            } else {
                this.out.print(", ");
            }
            this.out.print(param);
        }
        this.out.print("|");
        if (function.isVarargs()) {
            this.out.print(" (varargs)");
        }
        if (function.isSynthetic()) {
            this.out.format(" (synthetic, %s synthetic parameters)", function.getSyntheticParameterCount());
            if (function.getSyntheticSelfName() != null) {
                this.out.append(" (selfname: ").append(function.getSyntheticSelfName()).append(")");
            }
        }
        this.out.println();
        function.walk(this);
    }

    @Override
    public void visitDecorator(Decorator decorator) {
        this.incr();
        this.space();
        this.out.println("@Decorator");
        decorator.walk(this);
        this.decr();
    }

    @Override
    public void visitBlock(Block block) {
        if (block.isEmpty()) {
            return;
        }
        this.incr();
        this.space();
        this.out.print("Block");
        this.out.print(" [Local References: ");
        this.out.print(System.identityHashCode(block.getReferenceTable()));
        this.out.print(" -> ");
        this.out.print(System.identityHashCode(block.getReferenceTable().parent()));
        this.out.println("]");
        block.walk(this);
        this.decr();
    }

    @Override
    public void visitLocalReference(LocalReference ref) {
        this.incr();
        this.space();
        this.out.append(" - ").println(ref);
        this.decr();
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        this.incr();
        this.space();
        Object v = constantStatement.value();
        this.out.append("Constant = ").print(v);
        if (v != null) {
            this.out.append(" (").append(v.getClass().getName()).append(")");
        }
        this.out.println();
        this.decr();
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        this.incr();
        this.space();
        this.out.println("Return");
        returnStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        this.incr();
        this.space();
        this.out.append("Function call: ").print(functionInvocation.getName());
        this.out.append(", on reference? -> ").print(functionInvocation.isOnReference());
        this.out.append(", on module state? -> ").print(functionInvocation.isOnModuleState());
        this.out.append(", anonymous? -> ").print(functionInvocation.isAnonymous());
        this.out.append(", constant? -> ").print(functionInvocation.isConstant());
        this.out.append(", named arguments? -> ").println(functionInvocation.usesNamedArguments());
        functionInvocation.walk(this);
        this.printLocalDeclarations(functionInvocation);
        this.decr();
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        this.incr();
        this.space();
        this.out.append("Assignment: ").append(assignmentStatement.getLocalReference().toString()).println(assignmentStatement.isDeclaring() ? " (declaring)" : "");
        assignmentStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitDestructuringAssignment(DestructuringAssignment assignment) {
        this.incr();
        this.space();
        this.out.format("Destructuring assignement: {declaring=%s, varargs=%s}%n", assignment.isDeclaring(), assignment.isVarargs());
        assignment.walk(this);
        this.decr();
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        this.incr();
        this.space();
        this.out.append("Reference lookup: ").println(referenceLookup.getName());
        this.printLocalDeclarations(referenceLookup);
        this.decr();
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        this.incr();
        this.space();
        this.out.println("Conditional");
        conditionalBranching.walk(this);
        this.decr();
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        this.incr();
        this.space();
        this.out.println("Case");
        this.incr();
        for (WhenClause<Block> c : caseStatement.getClauses()) {
            c.accept(this);
        }
        this.space();
        this.out.println("Otherwise");
        caseStatement.getOtherwise().accept(this);
        this.decr();
    }

    @Override
    public void visitMatchExpression(MatchExpression matchExpression) {
        this.incr();
        this.space();
        this.out.println("Match");
        this.incr();
        for (WhenClause<ExpressionStatement<?>> c : matchExpression.getClauses()) {
            c.accept(this);
        }
        this.space();
        this.out.println("Otherwise");
        matchExpression.getOtherwise().accept(this);
        this.printLocalDeclarations(matchExpression);
        this.decr();
    }

    @Override
    public void visitWhenClause(WhenClause<?> whenClause) {
        this.space();
        this.out.println("When");
        this.incr();
        whenClause.walk(this);
        this.decr();
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        this.incr();
        this.space();
        this.out.append("Binary operator: ").println((Object)binaryOperation.getType());
        binaryOperation.walk(this);
        this.printLocalDeclarations(binaryOperation);
        this.decr();
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        this.incr();
        this.space();
        this.out.append("Unary operator: ").println((Object)unaryOperation.getType());
        unaryOperation.walk(this);
        this.printLocalDeclarations(unaryOperation);
        this.decr();
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        this.incr();
        this.space();
        this.out.println("Loop");
        loopStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitForEachLoopStatement(ForEachLoopStatement foreachStatement) {
        this.incr();
        this.space();
        this.out.println("Foreach");
        this.incr();
        for (LocalReference ref : foreachStatement.getReferences()) {
            ref.accept(this);
        }
        foreachStatement.getIterable().accept(this);
        if (foreachStatement.hasWhenClause()) {
            this.space();
            this.out.println("When:");
            foreachStatement.getWhenClause().accept(this);
        }
        foreachStatement.getBlock().accept(this);
        this.decr();
        this.decr();
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        this.incr();
        this.space();
        this.out.format("Method invocation: %s, null safe? -> %s%n", methodInvocation.getName(), methodInvocation.isNullSafeGuarded());
        methodInvocation.walk(this);
        this.printLocalDeclarations(methodInvocation);
        this.decr();
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        this.incr();
        this.space();
        this.out.println("Throw");
        throwStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        this.incr();
        this.space();
        this.out.println("Try");
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            this.space();
            this.out.append("Catch: ").println(tryCatchFinally.getExceptionId());
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            this.space();
            this.out.println("Finally");
            tryCatchFinally.getFinallyBlock().accept(this);
        }
        this.decr();
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        this.incr();
        this.space();
        if (target.isAnonymous()) {
            this.out.print("Closure: ");
            this.incr();
            this.visitFunctionDefinition(target);
            this.decr();
        } else {
            this.out.printf("Closure reference: %s, regular arguments at index %d%n", target.getName(), target.getSyntheticParameterCount());
            this.incr();
            for (String refName : closureReference.getCapturedReferenceNames()) {
                this.space();
                this.out.append("- capture: ").println(refName);
            }
            this.decr();
        }
        this.decr();
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        this.incr();
        this.space();
        this.out.append("Loop break flow: ").println(loopBreakFlowStatement.getType().name());
        this.decr();
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        this.incr();
        this.space();
        this.out.append("Collection literal of type: ").println((Object)collectionLiteral.getType());
        collectionLiteral.walk(this);
        this.printLocalDeclarations(collectionLiteral);
        this.decr();
    }

    @Override
    public void visitCollectionComprehension(CollectionComprehension collectionComprehension) {
        this.incr();
        this.space();
        this.out.append("Collection comprehension of type: ").println((Object)collectionComprehension.getType());
        this.incr();
        this.space();
        this.out.println("Expression: ");
        collectionComprehension.expression().accept(this);
        this.space();
        this.out.println("Comprehension: ");
        for (GoloStatement<?> b : collectionComprehension.loops()) {
            b.accept(this);
        }
        this.printLocalDeclarations(collectionComprehension);
        this.decr();
        this.decr();
    }

    @Override
    public void visitNamedArgument(NamedArgument namedArgument) {
        this.incr();
        this.space();
        this.out.append("Named argument: ").println(namedArgument.getName());
        namedArgument.expression().accept(this);
        this.decr();
    }

    @Override
    public void visitMember(Member member) {
        this.space();
        this.out.print(" - ");
        this.out.print(member.getName());
        this.out.println();
    }

    private void printLocalDeclarations(ExpressionStatement<?> expr) {
        if (expr.hasLocalDeclarations()) {
            this.incr();
            this.space();
            System.out.println("Local declaration:");
            for (GoloAssignment<?> a : expr.declarations()) {
                a.accept(this);
            }
            this.decr();
        }
    }

    @Override
    public void visitNoop(Noop noop) {
        this.incr();
        this.space();
        this.out.append("Noop: ").println(noop.comment());
        this.decr();
    }

    @Override
    public void visitToplevelElements(ToplevelElements toplevel) {
        toplevel.walk(this);
    }
}

