/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.AbstractInvocation;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.ReferenceLookup;
import java.lang.reflect.Method;

public final class FunctionInvocation
extends AbstractInvocation<FunctionInvocation> {
    private boolean onReference = false;
    private boolean onModuleState = false;
    private boolean anonymous = false;
    private boolean constant = false;

    private FunctionInvocation() {
        super("anonymous");
        this.anonymous = true;
    }

    private FunctionInvocation(String name) {
        super(name);
    }

    public static FunctionInvocation create(String name, boolean onReference, boolean onModuleState, boolean constant, Object ... args) {
        return FunctionInvocation.of(name).onReference(onReference).onModuleState(onModuleState).constant(constant).withArgs(args);
    }

    public static FunctionInvocation of(Object name) {
        if (name == null || "".equals(name)) {
            return new FunctionInvocation();
        }
        if (name instanceof FunctionInvocation) {
            return (FunctionInvocation)name;
        }
        if (name instanceof GoloFunction) {
            return new FunctionInvocation(((GoloFunction)name).getName());
        }
        if (name instanceof Method) {
            Method m = (Method)name;
            return new FunctionInvocation(m.getDeclaringClass().getCanonicalName() + "." + m.getName());
        }
        if (name instanceof ReferenceLookup) {
            return new FunctionInvocation(((ReferenceLookup)name).getName()).onReference(true);
        }
        return new FunctionInvocation(name.toString());
    }

    @Override
    protected FunctionInvocation self() {
        return this;
    }

    public FunctionInvocation onReference(boolean isOnReference) {
        this.onReference = isOnReference;
        return this;
    }

    public FunctionInvocation onReference() {
        return this.onReference(true);
    }

    public boolean isOnReference() {
        return this.onReference;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public FunctionInvocation onModuleState(boolean isOnModuleState) {
        this.onModuleState = isOnModuleState;
        return this;
    }

    public FunctionInvocation onModuleState() {
        return this.onModuleState(true);
    }

    public boolean isOnModuleState() {
        return this.onModuleState;
    }

    public FunctionInvocation constant(boolean isConstant) {
        this.constant = isConstant;
        return this;
    }

    public FunctionInvocation constant() {
        return this.constant(true);
    }

    public boolean isConstant() {
        return this.constant;
    }

    protected FunctionInvocation copy() {
        return FunctionInvocation.create(this.anonymous ? null : this.getName(), this.onReference, this.onModuleState, this.constant, this.getArguments().toArray());
    }

    @Override
    public FunctionInvocation withArgs(Object ... arguments) {
        super.withArgs(arguments);
        return this;
    }

    public String toString() {
        return String.format("FunctionInvocation{name=%s, arity=%s}", this.getName(), this.getArity());
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitFunctionInvocation(this);
    }
}

