/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.BinaryOperation;
import gololang.ir.ClosureReference;
import gololang.ir.ExpressionStatement;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.OperatorType;
import gololang.ir.ReferenceLookup;
import java.util.Collections;
import java.util.List;

public final class Decorator
extends GoloElement<Decorator> {
    private ExpressionStatement<?> expressionStatement;
    private boolean constant = false;

    private Decorator(ExpressionStatement<?> expressionStatement) {
        this.setExpressionStatement(expressionStatement);
    }

    public static Decorator of(Object expr) {
        if (expr instanceof Decorator) {
            return (Decorator)expr;
        }
        return new Decorator(ExpressionStatement.of(expr));
    }

    @Override
    protected Decorator self() {
        return this;
    }

    public ExpressionStatement<?> expression() {
        return this.expressionStatement;
    }

    private boolean isValidDecoratorExpressoin(ExpressionStatement<?> expr) {
        return expr instanceof ReferenceLookup || expr instanceof FunctionInvocation || expr instanceof ClosureReference || expr instanceof BinaryOperation && OperatorType.ANON_CALL.equals((Object)((BinaryOperation)expr).getType());
    }

    private void setExpressionStatement(ExpressionStatement<?> expr) {
        if (!this.isValidDecoratorExpressoin(expr)) {
            throw new IllegalArgumentException("Decorator expression must be a reference or an invocation, got a " + expr.getClass().getSimpleName());
        }
        this.expressionStatement = this.makeParentOf(expr);
    }

    public boolean isConstant() {
        return this.constant;
    }

    public Decorator constant(boolean constant) {
        this.constant = constant;
        return this;
    }

    public Decorator constant() {
        return this.constant(true);
    }

    private ExpressionStatement<?> wrapLookup(ReferenceLookup reference, ExpressionStatement<?> expression) {
        return FunctionInvocation.of(reference.getName()).constant(this.isConstant()).withArgs(expression);
    }

    private ExpressionStatement<?> wrapInvocation(FunctionInvocation invocation, ExpressionStatement<?> expression) {
        return invocation.call(FunctionInvocation.of(null).constant(this.isConstant()).withArgs(expression));
    }

    private ExpressionStatement<?> wrapAnonymousCall(ExpressionStatement<?> call, ExpressionStatement<?> expression) {
        return call.call(FunctionInvocation.of(null).constant(this.isConstant()).withArgs(expression));
    }

    public ExpressionStatement<?> wrapExpression(ExpressionStatement<?> expression) {
        if (this.expressionStatement instanceof ReferenceLookup) {
            return this.wrapLookup((ReferenceLookup)this.expressionStatement, expression);
        }
        if (this.expressionStatement instanceof FunctionInvocation) {
            return this.wrapInvocation((FunctionInvocation)this.expressionStatement, expression);
        }
        return this.wrapAnonymousCall(this.expressionStatement, expression);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitDecorator(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        return Collections.singletonList(this.expressionStatement);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.expressionStatement.equals(original) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement(ExpressionStatement.of(newElement));
    }

    public String toString() {
        return "Decorator{" + this.expressionStatement + "}";
    }
}

