/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CollectionLiteral
extends ExpressionStatement<CollectionLiteral> {
    private final Type type;
    private final List<ExpressionStatement<?>> expressions = new LinkedList();

    private CollectionLiteral(Type type) {
        this.type = type;
    }

    public static CollectionLiteral create(Object type, Object ... values) {
        CollectionLiteral col = new CollectionLiteral(type instanceof Type ? (Type)((Object)type) : Type.valueOf(type.toString()));
        for (Object v : values) {
            col.add(v);
        }
        return col;
    }

    @Override
    protected CollectionLiteral self() {
        return this;
    }

    public CollectionLiteral add(Object expression) {
        this.expressions.add(this.makeParentOf(ExpressionStatement.of(expression)));
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public List<ExpressionStatement<?>> getExpressions() {
        return this.expressions;
    }

    public String toString() {
        return this.type.toString() + this.expressions.toString();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitCollectionLiteral(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        return Collections.unmodifiableList(this.expressions);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.expressions.contains(original) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.expressions.set(this.expressions.indexOf(original), ExpressionStatement.of(newElement));
    }

    public static enum Type {
        array,
        list,
        set,
        map,
        tuple,
        vector,
        range;

    }
}

