/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.NamedArgument;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.PackageAndClass;

public abstract class AbstractInvocation<T extends AbstractInvocation<T>>
extends ExpressionStatement<T> {
    private PackageAndClass packageAndClass;
    private final List<GoloElement<?>> arguments = new LinkedList();
    protected boolean usesNamedArguments = false;

    AbstractInvocation(String name) {
        this.packageAndClass = PackageAndClass.of(name);
    }

    public String getName() {
        return this.packageAndClass.toString();
    }

    public String getModuleName() {
        if (this.packageAndClass == null) {
            return "";
        }
        return this.packageAndClass.packageName();
    }

    public String getFunctionName() {
        if (this.packageAndClass == null) {
            return "";
        }
        return this.packageAndClass.className();
    }

    public void setPackageAndClass(PackageAndClass name) {
        this.packageAndClass = name;
    }

    public PackageAndClass getPackageAndClass() {
        return this.packageAndClass;
    }

    private void addArgument(GoloElement<?> argument) {
        this.arguments.add(this.makeParentOf(argument));
        if (argument instanceof NamedArgument) {
            this.withNamedArguments();
        }
    }

    public T withArgs(Object ... arguments) {
        for (Object argument : arguments) {
            if (argument instanceof GoloElement) {
                this.addArgument((GoloElement)argument);
                continue;
            }
            this.addArgument(ExpressionStatement.of(argument));
        }
        return (T)((AbstractInvocation)this.self());
    }

    public List<GoloElement<?>> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public int getArity() {
        return this.arguments.size();
    }

    public boolean usesNamedArguments() {
        return this.usesNamedArguments;
    }

    public boolean namedArgumentsComplete() {
        return this.arguments.isEmpty() || this.usesNamedArguments;
    }

    public T withNamedArguments() {
        this.usesNamedArguments = true;
        return (T)((AbstractInvocation)this.self());
    }

    @Override
    public List<GoloElement<?>> children() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (this.arguments.contains(original)) {
            this.arguments.set(this.arguments.indexOf(original), newElement);
            this.makeParentOf(newElement);
            if (newElement instanceof NamedArgument) {
                this.withNamedArguments();
            }
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

