/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.golo.cli.command.Metadata;
import org.eclipse.golo.compiler.GoloCompiler;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Augmentation;
import org.eclipse.golo.compiler.ir.BinaryOperation;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.CaseStatement;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.CollectionComprehension;
import org.eclipse.golo.compiler.ir.CollectionLiteral;
import org.eclipse.golo.compiler.ir.ConditionalBranching;
import org.eclipse.golo.compiler.ir.ConstantStatement;
import org.eclipse.golo.compiler.ir.Decorator;
import org.eclipse.golo.compiler.ir.DestructuringAssignment;
import org.eclipse.golo.compiler.ir.ForEachLoopStatement;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.LoopBreakFlowStatement;
import org.eclipse.golo.compiler.ir.LoopStatement;
import org.eclipse.golo.compiler.ir.MatchExpression;
import org.eclipse.golo.compiler.ir.Member;
import org.eclipse.golo.compiler.ir.MethodInvocation;
import org.eclipse.golo.compiler.ir.ModuleImport;
import org.eclipse.golo.compiler.ir.NamedArgument;
import org.eclipse.golo.compiler.ir.NamedAugmentation;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.ir.ReturnStatement;
import org.eclipse.golo.compiler.ir.Struct;
import org.eclipse.golo.compiler.ir.ThrowStatement;
import org.eclipse.golo.compiler.ir.TryCatchFinally;
import org.eclipse.golo.compiler.ir.UnaryOperation;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.ir.UnionValue;
import org.eclipse.golo.compiler.ir.WhenClause;
import org.eclipse.golo.doc.AugmentationDocumentation;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.FunctionDocumentation;
import org.eclipse.golo.doc.MemberHolder;
import org.eclipse.golo.doc.NamedAugmentationDocumentation;
import org.eclipse.golo.doc.StructDocumentation;
import org.eclipse.golo.doc.UnionDocumentation;

public class ModuleDocumentation
implements DocumentationElement {
    private String moduleName;
    private int moduleDefLine;
    private String moduleDocumentation;
    private final Map<String, Integer> imports = new TreeMap<String, Integer>();
    private final Map<String, Integer> moduleStates = new TreeMap<String, Integer>();
    private final SortedSet<FunctionDocumentation> functions = new TreeSet<FunctionDocumentation>();
    private final Map<String, AugmentationDocumentation> augmentations = new TreeMap<String, AugmentationDocumentation>();
    private final SortedSet<StructDocumentation> structs = new TreeSet<StructDocumentation>();
    private final SortedSet<UnionDocumentation> unions = new TreeSet<UnionDocumentation>();
    private final Set<NamedAugmentationDocumentation> namedAugmentations = new TreeSet<NamedAugmentationDocumentation>();

    @Override
    public String type() {
        return "module";
    }

    ModuleDocumentation(GoloModule module) {
        module.accept(new ModuleVisitor());
    }

    public static ModuleDocumentation load(String filename, GoloCompiler compiler) throws IOException {
        return new ModuleDocumentation(compiler.transform(compiler.parse(filename)));
    }

    public String goloVersion() {
        return Metadata.VERSION;
    }

    public SortedSet<StructDocumentation> structs() {
        return this.structs;
    }

    public SortedSet<UnionDocumentation> unions() {
        return this.unions;
    }

    public SortedSet<FunctionDocumentation> functions() {
        return this.functions(false);
    }

    public SortedSet<FunctionDocumentation> functions(boolean withLocal) {
        if (withLocal) {
            return this.functions;
        }
        TreeSet<FunctionDocumentation> pubFunctions = new TreeSet<FunctionDocumentation>();
        for (FunctionDocumentation f : this.functions) {
            if (f.local()) continue;
            pubFunctions.add(f);
        }
        return pubFunctions;
    }

    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public String name() {
        return this.moduleName;
    }

    @Override
    public String fullName() {
        return this.moduleName;
    }

    @Override
    public String id() {
        return "";
    }

    @Override
    public DocumentationElement parent() {
        return this;
    }

    public int moduleDefLine() {
        return this.moduleDefLine;
    }

    @Override
    public int line() {
        return this.moduleDefLine;
    }

    public String moduleDocumentation() {
        return this.moduleDocumentation != null ? this.moduleDocumentation : "\n";
    }

    @Override
    public String documentation() {
        return this.moduleDocumentation();
    }

    public Map<String, Integer> moduleStates() {
        return this.moduleStates;
    }

    public Collection<AugmentationDocumentation> augmentations() {
        return this.augmentations.values();
    }

    public Collection<NamedAugmentationDocumentation> namedAugmentations() {
        return this.namedAugmentations;
    }

    public Map<String, Integer> imports() {
        return this.imports;
    }

    private class ModuleVisitor
    implements GoloIrVisitor {
        private Deque<Set<FunctionDocumentation>> functionContext = new LinkedList<Set<FunctionDocumentation>>();
        private FunctionDocumentation currentFunction = null;
        private UnionDocumentation currentUnion;
        private MemberHolder currentMemberHolder;
        private Deque<DocumentationElement> parents = new LinkedList<DocumentationElement>();

        private ModuleVisitor() {
        }

        @Override
        public void visitModule(GoloModule module) {
            this.functionContext.push(ModuleDocumentation.this.functions);
            this.parents.push(ModuleDocumentation.this);
            ModuleDocumentation.this.moduleName = module.getPackageAndClass().toString();
            ModuleDocumentation.this.moduleDefLine = module.getPositionInSourceCode().getLine();
            ModuleDocumentation.this.moduleDocumentation = module.getDocumentation();
            module.walk(this);
        }

        @Override
        public void visitModuleImport(ModuleImport moduleImport) {
            if (!moduleImport.isImplicit()) {
                ModuleDocumentation.this.imports.put(moduleImport.getPackageAndClass().toString(), moduleImport.getPositionInSourceCode().getLine());
            }
        }

        @Override
        public void visitStruct(Struct struct) {
            StructDocumentation doc = new StructDocumentation().parent(this.parents.peek()).name(struct.getName()).documentation(struct.getDocumentation()).line(struct.getPositionInSourceCode().getLine());
            ModuleDocumentation.this.structs.add(doc);
            this.currentMemberHolder = doc;
            this.parents.push(doc);
            struct.walk(this);
            this.parents.pop();
            this.currentMemberHolder = null;
        }

        @Override
        public void visitUnion(Union union) {
            this.currentUnion = new UnionDocumentation().parent(this.parents.peek()).name(union.getName()).documentation(union.getDocumentation()).line(union.getPositionInSourceCode().getLine());
            ModuleDocumentation.this.unions.add(this.currentUnion);
            this.parents.push(this.currentUnion);
            union.walk(this);
            this.parents.pop();
        }

        @Override
        public void visitUnionValue(UnionValue value) {
            UnionDocumentation.UnionValueDocumentation doc = this.currentUnion.addValue(value.getName()).parent(this.parents.peek()).documentation(value.getDocumentation()).line(value.getPositionInSourceCode().getLine());
            this.currentMemberHolder = doc;
            this.parents.push(doc);
            value.walk(this);
            this.parents.pop();
            this.currentMemberHolder = null;
        }

        @Override
        public void visitAugmentation(Augmentation augment) {
            String target = augment.getTarget().toString();
            if (!ModuleDocumentation.this.augmentations.containsKey(target)) {
                ModuleDocumentation.this.augmentations.put(target, new AugmentationDocumentation().target(target).parent(this.parents.peek()).augmentationNames(augment.getNames()).line(augment.getPositionInSourceCode().getLine()));
            }
            AugmentationDocumentation ad = (AugmentationDocumentation)ModuleDocumentation.this.augmentations.get(target);
            ad.documentation(ad.documentation() + '\n' + augment.getDocumentation());
            this.functionContext.push(ad);
            this.parents.push(ad);
            augment.walk(this);
            this.functionContext.pop();
            this.parents.pop();
        }

        @Override
        public void visitNamedAugmentation(NamedAugmentation augment) {
            NamedAugmentationDocumentation augmentDoc = new NamedAugmentationDocumentation().parent(this.parents.peek()).name(augment.getName()).documentation(augment.getDocumentation()).line(augment.getPositionInSourceCode().getLine());
            ModuleDocumentation.this.namedAugmentations.add(augmentDoc);
            this.functionContext.push(augmentDoc);
            this.parents.push(augmentDoc);
            augment.walk(this);
            this.functionContext.pop();
            this.parents.pop();
        }

        @Override
        public void visitFunction(GoloFunction function) {
            if (!"<clinit>".equals(function.getName())) {
                this.functionContext.peek().add(new FunctionDocumentation().parent(this.parents.peek()).name(function.getName()).documentation(function.getDocumentation()).augmentation(function.isInAugment()).line(function.getPositionInSourceCode().getLine()).local(function.isLocal()).arguments(function.getParameterNames()).varargs(function.isVarargs()));
            }
        }

        @Override
        public void visitLocalReference(LocalReference localRef) {
            if (localRef.isModuleState()) {
                ModuleDocumentation.this.moduleStates.put(localRef.getName(), localRef.getPositionInSourceCode().getLine());
            }
        }

        @Override
        public void visitMember(Member member) {
            this.currentMemberHolder.addMember(member.getName()).parent(this.parents.peek()).documentation(member.getDocumentation()).line(member.getPositionInSourceCode().getLine());
        }

        @Override
        public void visitDecorator(Decorator decorator) {
        }

        @Override
        public void visitBlock(Block block) {
        }

        @Override
        public void visitConstantStatement(ConstantStatement constantStatement) {
        }

        @Override
        public void visitReturnStatement(ReturnStatement returnStatement) {
        }

        @Override
        public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        }

        @Override
        public void visitMethodInvocation(MethodInvocation methodInvocation) {
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        }

        @Override
        public void visitDestructuringAssignment(DestructuringAssignment assignment) {
        }

        @Override
        public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        }

        @Override
        public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        }

        @Override
        public void visitBinaryOperation(BinaryOperation binaryOperation) {
        }

        @Override
        public void visitUnaryOperation(UnaryOperation unaryOperation) {
        }

        @Override
        public void visitLoopStatement(LoopStatement loopStatement) {
        }

        @Override
        public void visitForEachLoopStatement(ForEachLoopStatement foreachStatement) {
        }

        @Override
        public void visitCaseStatement(CaseStatement caseStatement) {
        }

        @Override
        public void visitMatchExpression(MatchExpression matchExpression) {
        }

        @Override
        public void visitWhenClause(WhenClause<?> whenClause) {
        }

        @Override
        public void visitThrowStatement(ThrowStatement throwStatement) {
        }

        @Override
        public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        }

        @Override
        public void visitClosureReference(ClosureReference closureReference) {
        }

        @Override
        public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        }

        @Override
        public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        }

        @Override
        public void visitCollectionComprehension(CollectionComprehension collectionComprehension) {
        }

        @Override
        public void visitNamedArgument(NamedArgument namedArgument) {
        }
    }
}

