/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.eclipse.golo.runtime.Module;

public final class ClassReferenceSupport {
    private ClassReferenceSupport() {
        throw new UnsupportedOperationException("Don't instantiate invokedynamic bootstrap class");
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) throws ClassNotFoundException {
        String className = name.replaceAll("#", "\\.");
        Class<?> callerClass = caller.lookupClass();
        ClassLoader classLoader = callerClass.getClassLoader();
        Class<?> classRef = ClassReferenceSupport.tryLoadingFromPrimitiveType(className);
        if (classRef != null) {
            return ClassReferenceSupport.createCallSite(classRef);
        }
        classRef = ClassReferenceSupport.tryLoadingFromName(className, classLoader);
        if (classRef != null) {
            return ClassReferenceSupport.createCallSite(classRef);
        }
        classRef = ClassReferenceSupport.tryLoadingFromImports(className, callerClass, classLoader);
        if (classRef != null) {
            return ClassReferenceSupport.createCallSite(classRef);
        }
        throw new ClassNotFoundException("Dynamic resolution failed for name: " + name);
    }

    private static Class<?> tryLoadingFromName(String name, ClassLoader classLoader) {
        try {
            return Class.forName(name, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> tryLoadingFromImports(String className, Class<?> callerClass, ClassLoader classLoader) {
        for (String importClassName : Module.imports(callerClass)) {
            Class<?> classRef = ClassReferenceSupport.tryLoadingFromName(importClassName + "." + className, classLoader);
            if (classRef != null) {
                return classRef;
            }
            if (!importClassName.endsWith(className) || (classRef = ClassReferenceSupport.tryLoadingFromName(importClassName, classLoader)) == null) continue;
            return classRef;
        }
        return null;
    }

    private static Class<?> tryLoadingFromPrimitiveType(String name) {
        switch (name) {
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    private static CallSite createCallSite(Class<?> classRef) {
        return new ConstantCallSite(MethodHandles.constant(Class.class, classRef));
    }
}

