/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import gololang.FunctionReference;
import gololang.Predefined;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.ModuleDocumentation;

public class MarkdownProcessor
extends AbstractProcessor {
    @Override
    public String render(ASTCompilationUnit compilationUnit) throws Throwable {
        FunctionReference template = this.template("template", "markdown");
        ModuleDocumentation documentation = new ModuleDocumentation(compilationUnit);
        return (String)template.handle().invokeWithArguments(documentation);
    }

    @Override
    public void process(Map<String, ASTCompilationUnit> units, Path targetFolder) throws Throwable {
        TreeMap<String, String> moduleDocFile = new TreeMap<String, String>();
        this.ensureFolderExists(targetFolder);
        for (ASTCompilationUnit unit : units.values()) {
            String moduleName = this.moduleName(unit);
            Path docFile = this.outputFile(targetFolder, moduleName, ".markdown");
            this.ensureFolderExists(docFile.getParent());
            Predefined.textToFile(this.render(unit), docFile);
            moduleDocFile.put(moduleName, targetFolder.relativize(docFile).toString());
        }
        FunctionReference indexTemplate = this.template("index", "markdown");
        String index = (String)indexTemplate.handle().invokeWithArguments(moduleDocFile);
        Predefined.textToFile(index, targetFolder.resolve("index.markdown"));
    }
}

